// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeWorkteamResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.Workteam
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeWorkteamOperationDeserializer: HttpDeserialize<DescribeWorkteamResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeWorkteamResponse {
        if (!response.status.isSuccess()) {
            throwDescribeWorkteamError(context, response)
        }
        val builder = DescribeWorkteamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeWorkteamOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeWorkteamError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWorkteamOperationBody(builder: DescribeWorkteamResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WORKTEAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Workteam"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WORKTEAM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WORKTEAM_DESCRIPTOR.index -> builder.workteam = deserializeWorkteamDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
