// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse
import aws.sdk.kotlin.services.sagemaker.model.ImageVersionStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeImageVersionOperationDeserializer: HttpDeserialize<DescribeImageVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeImageVersionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeImageVersionError(context, response)
        }
        val builder = DescribeImageVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeImageVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeImageVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImageVersionOperationBody(builder: DescribeImageVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaseImage"))
    val CONTAINERIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContainerImage"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val IMAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageArn"))
    val IMAGEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageVersionArn"))
    val IMAGEVERSIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageVersionStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEIMAGE_DESCRIPTOR)
        field(CONTAINERIMAGE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(IMAGEARN_DESCRIPTOR)
        field(IMAGEVERSIONARN_DESCRIPTOR)
        field(IMAGEVERSIONSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEIMAGE_DESCRIPTOR.index -> builder.baseImage = deserializeString()
                CONTAINERIMAGE_DESCRIPTOR.index -> builder.containerImage = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                IMAGEARN_DESCRIPTOR.index -> builder.imageArn = deserializeString()
                IMAGEVERSIONARN_DESCRIPTOR.index -> builder.imageVersionArn = deserializeString()
                IMAGEVERSIONSTATUS_DESCRIPTOR.index -> builder.imageVersionStatus = deserializeString().let { ImageVersionStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
