// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmStatus
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmStatusDetails
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationSpecification
import aws.sdk.kotlin.services.sagemaker.model.DescribeAlgorithmResponse
import aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAlgorithmOperationDeserializer: HttpDeserialize<DescribeAlgorithmResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAlgorithmResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAlgorithmError(context, response)
        }
        val builder = DescribeAlgorithmResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAlgorithmOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAlgorithmError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlgorithmOperationBody(builder: DescribeAlgorithmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmArn"))
    val ALGORITHMDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmDescription"))
    val ALGORITHMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmName"))
    val ALGORITHMSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmStatus"))
    val ALGORITHMSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlgorithmStatusDetails"))
    val CERTIFYFORMARKETPLACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CertifyForMarketplace"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val INFERENCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferenceSpecification"))
    val PRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductId"))
    val TRAININGSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingSpecification"))
    val VALIDATIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMARN_DESCRIPTOR)
        field(ALGORITHMDESCRIPTION_DESCRIPTOR)
        field(ALGORITHMNAME_DESCRIPTOR)
        field(ALGORITHMSTATUS_DESCRIPTOR)
        field(ALGORITHMSTATUSDETAILS_DESCRIPTOR)
        field(CERTIFYFORMARKETPLACE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(INFERENCESPECIFICATION_DESCRIPTOR)
        field(PRODUCTID_DESCRIPTOR)
        field(TRAININGSPECIFICATION_DESCRIPTOR)
        field(VALIDATIONSPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHMARN_DESCRIPTOR.index -> builder.algorithmArn = deserializeString()
                ALGORITHMDESCRIPTION_DESCRIPTOR.index -> builder.algorithmDescription = deserializeString()
                ALGORITHMNAME_DESCRIPTOR.index -> builder.algorithmName = deserializeString()
                ALGORITHMSTATUS_DESCRIPTOR.index -> builder.algorithmStatus = deserializeString().let { AlgorithmStatus.fromValue(it) }
                ALGORITHMSTATUSDETAILS_DESCRIPTOR.index -> builder.algorithmStatusDetails = deserializeAlgorithmStatusDetailsDocument(deserializer)
                CERTIFYFORMARKETPLACE_DESCRIPTOR.index -> builder.certifyForMarketplace = deserializeBoolean()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                INFERENCESPECIFICATION_DESCRIPTOR.index -> builder.inferenceSpecification = deserializeInferenceSpecificationDocument(deserializer)
                PRODUCTID_DESCRIPTOR.index -> builder.productId = deserializeString()
                TRAININGSPECIFICATION_DESCRIPTOR.index -> builder.trainingSpecification = deserializeTrainingSpecificationDocument(deserializer)
                VALIDATIONSPECIFICATION_DESCRIPTOR.index -> builder.validationSpecification = deserializeAlgorithmValidationSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
