// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.CognitoConfig
import aws.sdk.kotlin.services.sagemaker.model.CreateWorkforceRequest
import aws.sdk.kotlin.services.sagemaker.model.OidcConfig
import aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateWorkforceOperationSerializer: HttpSerialize<CreateWorkforceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateWorkforceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateWorkforceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        return builder
    }
}

private fun serializeCreateWorkforceOperationBody(context: ExecutionContext, input: CreateWorkforceRequest): ByteArray {
    val serializer = JsonSerializer()
    val COGNITOCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CognitoConfig"))
    val OIDCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OidcConfig"))
    val SOURCEIPCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceIpConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val WORKFORCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkforceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COGNITOCONFIG_DESCRIPTOR)
        field(OIDCCONFIG_DESCRIPTOR)
        field(SOURCEIPCONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(WORKFORCENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cognitoConfig?.let { field(COGNITOCONFIG_DESCRIPTOR, it, ::serializeCognitoConfigDocument) }
        input.oidcConfig?.let { field(OIDCCONFIG_DESCRIPTOR, it, ::serializeOidcConfigDocument) }
        input.sourceIpConfig?.let { field(SOURCEIPCONFIG_DESCRIPTOR, it, ::serializeSourceIpConfigDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.workforceName?.let { field(WORKFORCENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
