// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class UpdateNotebookInstanceRequest private constructor(builder: Builder) {
    /**
     * A list of the Elastic Inference (EI) instance types to associate with this notebook
     * instance. Currently only one EI instance type can be associated with a notebook
     * instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     * SageMaker.
     */
    val acceleratorTypes: List<NotebookInstanceAcceleratorType>? = builder.acceleratorTypes
    /**
     * An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account,
     * or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
     * other Git repository. These repositories are cloned at the same level as the default
     * repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
     * Repositories with Amazon SageMaker Notebook Instances.
     */
    val additionalCodeRepositories: List<String>? = builder.additionalCodeRepositories
    /**
     * The Git repository to associate with the notebook instance as its default code
     * repository. This can be either the name of a Git repository stored as a resource in your
     * account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
     * other Git repository. When you open a notebook instance, it opens in the directory that
     * contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
     * Notebook Instances.
     */
    val defaultCodeRepository: kotlin.String? = builder.defaultCodeRepository
    /**
     * A list of the Elastic Inference (EI) instance types to remove from this notebook
     * instance. This operation is idempotent. If you specify an accelerator type that is not
     * associated with the notebook instance when you call this method, it does not throw an
     * error.
     */
    val disassociateAcceleratorTypes: kotlin.Boolean = builder.disassociateAcceleratorTypes
    /**
     * A list of names or URLs of the default Git repositories to remove from this notebook
     * instance. This operation is idempotent. If you specify a Git repository that is not
     * associated with the notebook instance when you call this method, it does not throw an
     * error.
     */
    val disassociateAdditionalCodeRepositories: kotlin.Boolean = builder.disassociateAdditionalCodeRepositories
    /**
     * The name or URL of the default Git repository to remove from this notebook instance.
     * This operation is idempotent. If you specify a Git repository that is not associated
     * with the notebook instance when you call this method, it does not throw an error.
     */
    val disassociateDefaultCodeRepository: kotlin.Boolean = builder.disassociateDefaultCodeRepository
    /**
     * Set to true to remove the notebook instance lifecycle configuration
     * currently associated with the notebook instance. This operation is idempotent. If you
     * specify a lifecycle configuration that is not associated with the notebook instance when
     * you call this method, it does not throw an error.
     */
    val disassociateLifecycleConfig: kotlin.Boolean = builder.disassociateLifecycleConfig
    /**
     * The Amazon ML compute instance type.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = builder.instanceType
    /**
     * The name of a lifecycle configuration to associate with the notebook instance. For
     * information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance.
     */
    val lifecycleConfigName: kotlin.String? = builder.lifecycleConfigName
    /**
     * The name of the notebook instance to update.
     */
    val notebookInstanceName: kotlin.String? = builder.notebookInstanceName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the
     * notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.
     *
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     * iam:PassRole permission.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Whether root access is enabled or disabled for users of the notebook instance. The
     * default value is Enabled.
     *
     * If you set this to Disabled, users don't have root access on the
     * notebook instance, but lifecycle configuration scripts still run with root
     * permissions.
     */
    val rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = builder.rootAccess
    /**
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The
     * default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can't determine the
     * amount of available free space on the volume. Because of this, you can increase the
     * volume size when you update a notebook instance, but you can't decrease the volume size.
     * If you want to decrease the size of the ML storage volume in use, create a new notebook
     * instance with the desired size.
     */
    val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateNotebookInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNotebookInstanceRequest(")
        append("acceleratorTypes=$acceleratorTypes,")
        append("additionalCodeRepositories=$additionalCodeRepositories,")
        append("defaultCodeRepository=$defaultCodeRepository,")
        append("disassociateAcceleratorTypes=$disassociateAcceleratorTypes,")
        append("disassociateAdditionalCodeRepositories=$disassociateAdditionalCodeRepositories,")
        append("disassociateDefaultCodeRepository=$disassociateDefaultCodeRepository,")
        append("disassociateLifecycleConfig=$disassociateLifecycleConfig,")
        append("instanceType=$instanceType,")
        append("lifecycleConfigName=$lifecycleConfigName,")
        append("notebookInstanceName=$notebookInstanceName,")
        append("roleArn=$roleArn,")
        append("rootAccess=$rootAccess,")
        append("volumeSizeInGb=$volumeSizeInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorTypes?.hashCode() ?: 0
        result = 31 * result + (additionalCodeRepositories?.hashCode() ?: 0)
        result = 31 * result + (defaultCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (disassociateAcceleratorTypes.hashCode())
        result = 31 * result + (disassociateAdditionalCodeRepositories.hashCode())
        result = 31 * result + (disassociateDefaultCodeRepository.hashCode())
        result = 31 * result + (disassociateLifecycleConfig.hashCode())
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfigName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rootAccess?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNotebookInstanceRequest

        if (acceleratorTypes != other.acceleratorTypes) return false
        if (additionalCodeRepositories != other.additionalCodeRepositories) return false
        if (defaultCodeRepository != other.defaultCodeRepository) return false
        if (disassociateAcceleratorTypes != other.disassociateAcceleratorTypes) return false
        if (disassociateAdditionalCodeRepositories != other.disassociateAdditionalCodeRepositories) return false
        if (disassociateDefaultCodeRepository != other.disassociateDefaultCodeRepository) return false
        if (disassociateLifecycleConfig != other.disassociateLifecycleConfig) return false
        if (instanceType != other.instanceType) return false
        if (lifecycleConfigName != other.lifecycleConfigName) return false
        if (notebookInstanceName != other.notebookInstanceName) return false
        if (roleArn != other.roleArn) return false
        if (rootAccess != other.rootAccess) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateNotebookInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the Elastic Inference (EI) instance types to associate with this notebook
         * instance. Currently only one EI instance type can be associated with a notebook
         * instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker.
         */
        var acceleratorTypes: List<NotebookInstanceAcceleratorType>? = null
        /**
         * An array of up to three Git repositories to associate with the notebook instance.
         * These can be either the names of Git repositories stored as resources in your account,
         * or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
         * other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
         * Repositories with Amazon SageMaker Notebook Instances.
         */
        var additionalCodeRepositories: List<String>? = null
        /**
         * The Git repository to associate with the notebook instance as its default code
         * repository. This can be either the name of a Git repository stored as a resource in your
         * account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
         * other Git repository. When you open a notebook instance, it opens in the directory that
         * contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
         * Notebook Instances.
         */
        var defaultCodeRepository: kotlin.String? = null
        /**
         * A list of the Elastic Inference (EI) instance types to remove from this notebook
         * instance. This operation is idempotent. If you specify an accelerator type that is not
         * associated with the notebook instance when you call this method, it does not throw an
         * error.
         */
        var disassociateAcceleratorTypes: kotlin.Boolean = false
        /**
         * A list of names or URLs of the default Git repositories to remove from this notebook
         * instance. This operation is idempotent. If you specify a Git repository that is not
         * associated with the notebook instance when you call this method, it does not throw an
         * error.
         */
        var disassociateAdditionalCodeRepositories: kotlin.Boolean = false
        /**
         * The name or URL of the default Git repository to remove from this notebook instance.
         * This operation is idempotent. If you specify a Git repository that is not associated
         * with the notebook instance when you call this method, it does not throw an error.
         */
        var disassociateDefaultCodeRepository: kotlin.Boolean = false
        /**
         * Set to true to remove the notebook instance lifecycle configuration
         * currently associated with the notebook instance. This operation is idempotent. If you
         * specify a lifecycle configuration that is not associated with the notebook instance when
         * you call this method, it does not throw an error.
         */
        var disassociateLifecycleConfig: kotlin.Boolean = false
        /**
         * The Amazon ML compute instance type.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = null
        /**
         * The name of a lifecycle configuration to associate with the notebook instance. For
         * information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance.
         */
        var lifecycleConfigName: kotlin.String? = null
        /**
         * The name of the notebook instance to update.
         */
        var notebookInstanceName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the
         * notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.
         *
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * iam:PassRole permission.
         */
        var roleArn: kotlin.String? = null
        /**
         * Whether root access is enabled or disabled for users of the notebook instance. The
         * default value is Enabled.
         *
         * If you set this to Disabled, users don't have root access on the
         * notebook instance, but lifecycle configuration scripts still run with root
         * permissions.
         */
        var rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = null
        /**
         * The size, in GB, of the ML storage volume to attach to the notebook instance. The
         * default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can't determine the
         * amount of available free space on the volume. Because of this, you can increase the
         * volume size when you update a notebook instance, but you can't decrease the volume size.
         * If you want to decrease the size of the ML storage volume in use, create a new notebook
         * instance with the desired size.
         */
        var volumeSizeInGb: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateNotebookInstanceRequest) : this() {
            this.acceleratorTypes = x.acceleratorTypes
            this.additionalCodeRepositories = x.additionalCodeRepositories
            this.defaultCodeRepository = x.defaultCodeRepository
            this.disassociateAcceleratorTypes = x.disassociateAcceleratorTypes
            this.disassociateAdditionalCodeRepositories = x.disassociateAdditionalCodeRepositories
            this.disassociateDefaultCodeRepository = x.disassociateDefaultCodeRepository
            this.disassociateLifecycleConfig = x.disassociateLifecycleConfig
            this.instanceType = x.instanceType
            this.lifecycleConfigName = x.lifecycleConfigName
            this.notebookInstanceName = x.notebookInstanceName
            this.roleArn = x.roleArn
            this.rootAccess = x.rootAccess
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateNotebookInstanceRequest = UpdateNotebookInstanceRequest(this)
    }
}
