// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines the input needed to run a training job using the algorithm.
 */
class TrainingJobDefinition private constructor(builder: Builder) {
    /**
     * The hyperparameters used for the training job.
     */
    val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * An array of Channel objects, each of which specifies an input
     * source.
     */
    val inputDataConfig: List<Channel>? = builder.inputDataConfig
    /**
     * the path to the S3 bucket where you want to store model artifacts. Amazon SageMaker creates
     * subfolders for the artifacts.
     */
    val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The resources, including the ML compute instances and ML storage volumes, to use for
     * model training.
     */
    val resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = builder.resourceConfig
    /**
     * Specifies a limit to how long a model training job can run. It also specifies how long
     * a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker
     * ends the training job. Use this API to cap model training costs.
     * To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job
     * termination for 120 seconds. Algorithms can use this 120-second window to save the model
     * artifacts.
     */
    val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * The training input mode that the algorithm supports. For more information about input modes, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms.
     *
     *
     * Pipe mode
     *
     * If an algorithm supports Pipe mode, Amazon SageMaker streams data directly
     * from Amazon S3 to the container.
     *
     *
     * File mode
     *
     * If an algorithm supports File mode, SageMaker
     * downloads the training data from S3 to the provisioned ML storage volume, and mounts the
     * directory to the Docker volume for the training container.
     * You must provision the ML storage volume with sufficient capacity
     * to accommodate the data downloaded from S3. In addition to the training data, the ML
     * storage volume also stores the output model. The algorithm container uses the ML storage
     * volume to also store intermediate information, if any.
     * For distributed algorithms, training data is distributed uniformly.
     * Your training duration is predictable if the input data objects sizes are
     * approximately the same. SageMaker does not split the files any further for model training.
     * If the object sizes are skewed, training won't be optimal as the data distribution is also
     * skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in
     * training.
     *
     *
     * FastFile mode
     *
     * If an algorithm supports FastFile mode, SageMaker streams data directly
     * from S3 to the container with no code changes, and provides file system access to
     * the data. Users can author their training script to interact with these files as if
     * they were stored on disk.
     *
     * FastFile mode works best when the data is read sequentially.
     * Augmented manifest files aren't supported.
     * The startup time is lower when there are fewer files in the S3 bucket provided.
     */
    val trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = builder.trainingInputMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingJobDefinition(")
        append("hyperParameters=$hyperParameters,")
        append("inputDataConfig=$inputDataConfig,")
        append("outputDataConfig=$outputDataConfig,")
        append("resourceConfig=$resourceConfig,")
        append("stoppingCondition=$stoppingCondition,")
        append("trainingInputMode=$trainingInputMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hyperParameters?.hashCode() ?: 0
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (trainingInputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingJobDefinition

        if (hyperParameters != other.hyperParameters) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (resourceConfig != other.resourceConfig) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (trainingInputMode != other.trainingInputMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The hyperparameters used for the training job.
         */
        var hyperParameters: Map<String, String>? = null
        /**
         * An array of Channel objects, each of which specifies an input
         * source.
         */
        var inputDataConfig: List<Channel>? = null
        /**
         * the path to the S3 bucket where you want to store model artifacts. Amazon SageMaker creates
         * subfolders for the artifacts.
         */
        var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = null
        /**
         * The resources, including the ML compute instances and ML storage volumes, to use for
         * model training.
         */
        var resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = null
        /**
         * Specifies a limit to how long a model training job can run. It also specifies how long
         * a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker
         * ends the training job. Use this API to cap model training costs.
         * To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job
         * termination for 120 seconds. Algorithms can use this 120-second window to save the model
         * artifacts.
         */
        var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * The training input mode that the algorithm supports. For more information about input modes, see
         * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms.
         *
         *
         * Pipe mode
         *
         * If an algorithm supports Pipe mode, Amazon SageMaker streams data directly
         * from Amazon S3 to the container.
         *
         *
         * File mode
         *
         * If an algorithm supports File mode, SageMaker
         * downloads the training data from S3 to the provisioned ML storage volume, and mounts the
         * directory to the Docker volume for the training container.
         * You must provision the ML storage volume with sufficient capacity
         * to accommodate the data downloaded from S3. In addition to the training data, the ML
         * storage volume also stores the output model. The algorithm container uses the ML storage
         * volume to also store intermediate information, if any.
         * For distributed algorithms, training data is distributed uniformly.
         * Your training duration is predictable if the input data objects sizes are
         * approximately the same. SageMaker does not split the files any further for model training.
         * If the object sizes are skewed, training won't be optimal as the data distribution is also
         * skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in
         * training.
         *
         *
         * FastFile mode
         *
         * If an algorithm supports FastFile mode, SageMaker streams data directly
         * from S3 to the container with no code changes, and provides file system access to
         * the data. Users can author their training script to interact with these files as if
         * they were stored on disk.
         *
         * FastFile mode works best when the data is read sequentially.
         * Augmented manifest files aren't supported.
         * The startup time is lower when there are fewer files in the S3 bucket provided.
         */
        var trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition) : this() {
            this.hyperParameters = x.hyperParameters
            this.inputDataConfig = x.inputDataConfig
            this.outputDataConfig = x.outputDataConfig
            this.resourceConfig = x.resourceConfig
            this.stoppingCondition = x.stoppingCondition
            this.trainingInputMode = x.trainingInputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition = TrainingJobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceConfig] inside the given [block]
         */
        fun resourceConfig(block: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }
    }
}
