// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A tag object that consists of a key and an optional value, used to manage metadata
 * for SageMaker Amazon Web Services resources.
 * You can add tags to notebook instances, training jobs, hyperparameter tuning jobs,
 * batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and
 * endpoints. For more information on adding tags to SageMaker resources, see AddTags.
 * For more information on adding metadata to your Amazon Web Services resources with tagging, see
 * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
 * resources. For advice on best practices for managing Amazon Web Services resources with
 * tagging, see <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging
 * Best Practices: Implement an Effective Amazon Web Services Resource Tagging Strategy.
 */
class Tag private constructor(builder: Builder) {
    /**
     * The tag key. Tag keys must be unique per resource.
     */
    val key: kotlin.String? = builder.key
    /**
     * The tag value.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Tag = Builder(this).apply(block).build()

    class Builder {
        /**
         * The tag key. Tag keys must be unique per resource.
         */
        var key: kotlin.String? = null
        /**
         * The tag value.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Tag = Tag(this)
    }
}
