// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies an algorithm that was used to create the model package. The algorithm must
 * be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
 * are subscribed to.
 */
class SourceAlgorithm private constructor(builder: Builder) {
    /**
     * The name of an algorithm that was used to create the model package. The algorithm must
     * be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
     * are subscribed to.
     */
    val algorithmName: kotlin.String? = builder.algorithmName
    /**
     * The Amazon S3 path where the model artifacts, which result from model training, are stored.
     * This path must point to a single gzip compressed tar archive
     * (.tar.gz suffix).
     *
     * The model artifacts must be in an S3 bucket that is in the same region as the
     * algorithm.
     */
    val modelDataUrl: kotlin.String? = builder.modelDataUrl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceAlgorithm(")
        append("algorithmName=$algorithmName,")
        append("modelDataUrl=$modelDataUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmName?.hashCode() ?: 0
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceAlgorithm

        if (algorithmName != other.algorithmName) return false
        if (modelDataUrl != other.modelDataUrl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an algorithm that was used to create the model package. The algorithm must
         * be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
         * are subscribed to.
         */
        var algorithmName: kotlin.String? = null
        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored.
         * This path must point to a single gzip compressed tar archive
         * (.tar.gz suffix).
         *
         * The model artifacts must be in an S3 bucket that is in the same region as the
         * algorithm.
         */
        var modelDataUrl: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm) : this() {
            this.algorithmName = x.algorithmName
            this.modelDataUrl = x.modelDataUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = SourceAlgorithm(this)
    }
}
