// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Details of a provisioned service catalog product. For information about service catalog,
 * see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
 * Catalog.
 */
class ServiceCatalogProvisionedProductDetails private constructor(builder: Builder) {
    /**
     * The ID of the provisioned product.
     */
    val provisionedProductId: kotlin.String? = builder.provisionedProductId
    /**
     * The current status of the product.
     *
     *
     *
     * AVAILABLE - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
     *
     *
     * UNDER_CHANGE - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.
     *
     *
     * TAINTED - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
     *
     *
     * ERROR - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     *
     *
     * PLAN_IN_PROGRESS - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.
     */
    val provisionedProductStatusMessage: kotlin.String? = builder.provisionedProductStatusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceCatalogProvisionedProductDetails(")
        append("provisionedProductId=$provisionedProductId,")
        append("provisionedProductStatusMessage=$provisionedProductStatusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = provisionedProductId?.hashCode() ?: 0
        result = 31 * result + (provisionedProductStatusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceCatalogProvisionedProductDetails

        if (provisionedProductId != other.provisionedProductId) return false
        if (provisionedProductStatusMessage != other.provisionedProductStatusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the provisioned product.
         */
        var provisionedProductId: kotlin.String? = null
        /**
         * The current status of the product.
         *
         *
         *
         * AVAILABLE - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
         *
         *
         * UNDER_CHANGE - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.
         *
         *
         * TAINTED - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
         *
         *
         * ERROR - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
         *
         *
         * PLAN_IN_PROGRESS - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.
         */
        var provisionedProductStatusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails) : this() {
            this.provisionedProductId = x.provisionedProductId
            this.provisionedProductStatusMessage = x.provisionedProductStatusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails = ServiceCatalogProvisionedProductDetails(this)
    }
}
