// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An array element of DescribeTrainingJobResponse$SecondaryStatusTransitions. It provides
 * additional details about a status that the training job has transitioned through. A
 * training job can be in one of several states, for example, starting, downloading,
 * training, or uploading. Within each state, there are a number of intermediate states.
 * For example, within the starting state, Amazon SageMaker could be starting the training job or
 * launching the ML instances. These transitional states are referred to as the job's
 * secondary
 * status.
 */
class SecondaryStatusTransition private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the training job transitioned out of this secondary status
     * state into another secondary status state or when the training job has ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A timestamp that shows when the training job transitioned to the current secondary
     * status state.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Contains a secondary status information from a training
     * job.
     * Status might be one of the following secondary statuses:
     *
     * InProgress
     *
     *
     *
     *
     * Starting
     * - Starting the training job.
     *
     *
     *
     * Downloading - An optional stage for algorithms that
     * support File training input mode. It indicates that
     * data is being downloaded to the ML storage volumes.
     *
     *
     *
     * Training - Training is in progress.
     *
     *
     *
     * Uploading - Training is complete and the model
     * artifacts are being uploaded to the S3 location.
     *
     *
     *
     * Completed
     *
     *
     *
     *
     * Completed - The training job has completed.
     *
     *
     *
     * Failed
     *
     *
     *
     *
     * Failed - The training job has failed. The reason for
     * the failure is returned in the FailureReason field of
     * DescribeTrainingJobResponse.
     *
     *
     *
     * Stopped
     *
     *
     *
     *
     * MaxRuntimeExceeded - The job stopped because it
     * exceeded the maximum allowed runtime.
     *
     *
     *
     * Stopped - The training job has stopped.
     *
     *
     *
     * Stopping
     *
     *
     *
     *
     * Stopping - Stopping the training job.
     *
     *
     *
     *
     * We no longer support the following secondary statuses:
     *
     *
     *
     * LaunchingMLInstances
     *
     *
     *
     * PreparingTrainingStack
     *
     *
     *
     * DownloadingTrainingImage
     */
    val status: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = builder.status
    /**
     * A detailed description of the progress within a secondary status.
     *
     * Amazon SageMaker provides secondary statuses and status messages that apply to each of
     * them:
     *
     * Starting
     *
     *
     *
     * Starting the training job.
     *
     *
     * Launching requested ML
     * instances.
     *
     *
     * Insufficient
     * capacity error from EC2 while launching instances,
     * retrying!
     *
     *
     * Launched
     * instance was unhealthy, replacing it!
     *
     *
     * Preparing the instances for training.
     *
     *
     *
     * Training
     *
     *
     *
     * Downloading the training image.
     *
     *
     * Training
     * image download completed. Training in
     * progress.
     *
     *
     *
     *
     *
     * Status messages are subject to change. Therefore, we recommend not including them
     * in code that programmatically initiates actions. For examples, don't use status
     * messages in if statements.
     *
     * To have an overview of your training job's progress, view
     * TrainingJobStatus and SecondaryStatus in DescribeTrainingJob, and StatusMessage together. For
     * example, at the start of a training job, you might see the following:
     *
     *
     *
     * TrainingJobStatus - InProgress
     *
     *
     * SecondaryStatus - Training
     *
     *
     * StatusMessage - Downloading the training image
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SecondaryStatusTransition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecondaryStatusTransition(")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecondaryStatusTransition

        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SecondaryStatusTransition = Builder(this).apply(block).build()

    class Builder {
        /**
         * A timestamp that shows when the training job transitioned out of this secondary status
         * state into another secondary status state or when the training job has ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that shows when the training job transitioned to the current secondary
         * status state.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains a secondary status information from a training
         * job.
         * Status might be one of the following secondary statuses:
         *
         * InProgress
         *
         *
         *
         *
         * Starting
         * - Starting the training job.
         *
         *
         *
         * Downloading - An optional stage for algorithms that
         * support File training input mode. It indicates that
         * data is being downloaded to the ML storage volumes.
         *
         *
         *
         * Training - Training is in progress.
         *
         *
         *
         * Uploading - Training is complete and the model
         * artifacts are being uploaded to the S3 location.
         *
         *
         *
         * Completed
         *
         *
         *
         *
         * Completed - The training job has completed.
         *
         *
         *
         * Failed
         *
         *
         *
         *
         * Failed - The training job has failed. The reason for
         * the failure is returned in the FailureReason field of
         * DescribeTrainingJobResponse.
         *
         *
         *
         * Stopped
         *
         *
         *
         *
         * MaxRuntimeExceeded - The job stopped because it
         * exceeded the maximum allowed runtime.
         *
         *
         *
         * Stopped - The training job has stopped.
         *
         *
         *
         * Stopping
         *
         *
         *
         *
         * Stopping - Stopping the training job.
         *
         *
         *
         *
         * We no longer support the following secondary statuses:
         *
         *
         *
         * LaunchingMLInstances
         *
         *
         *
         * PreparingTrainingStack
         *
         *
         *
         * DownloadingTrainingImage
         */
        var status: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = null
        /**
         * A detailed description of the progress within a secondary status.
         *
         * Amazon SageMaker provides secondary statuses and status messages that apply to each of
         * them:
         *
         * Starting
         *
         *
         *
         * Starting the training job.
         *
         *
         * Launching requested ML
         * instances.
         *
         *
         * Insufficient
         * capacity error from EC2 while launching instances,
         * retrying!
         *
         *
         * Launched
         * instance was unhealthy, replacing it!
         *
         *
         * Preparing the instances for training.
         *
         *
         *
         * Training
         *
         *
         *
         * Downloading the training image.
         *
         *
         * Training
         * image download completed. Training in
         * progress.
         *
         *
         *
         *
         *
         * Status messages are subject to change. Therefore, we recommend not including them
         * in code that programmatically initiates actions. For examples, don't use status
         * messages in if statements.
         *
         * To have an overview of your training job's progress, view
         * TrainingJobStatus and SecondaryStatus in DescribeTrainingJob, and StatusMessage together. For
         * example, at the start of a training job, you might see the following:
         *
         *
         *
         * TrainingJobStatus - InProgress
         *
         *
         * SecondaryStatus - Training
         *
         *
         * StatusMessage - Downloading the training image
         */
        var statusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatusTransition) : this() {
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SecondaryStatusTransition = SecondaryStatusTransition(this)
    }
}
