// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A multi-expression that searches for the specified resource or resources in a search. All resource
 * objects that satisfy the expression's condition are included in the search results. You must specify at
 * least one subexpression, filter, or nested filter. A SearchExpression can contain up to
 * twenty elements.
 * A SearchExpression contains the following components:
 *
 *
 * A list of Filter objects. Each filter defines a simple Boolean
 * expression comprised of a resource property name, Boolean operator, and
 * value.
 *
 * A list of NestedFilter objects. Each nested filter defines a list
 * of Boolean expressions using a list of resource properties. A nested filter is
 * satisfied if a single object in the list satisfies all Boolean
 * expressions.
 *
 * A list of SearchExpression objects. A search expression object
 * can be nested in a list of search expression objects.
 *
 * A Boolean operator: And or Or.
 */
class SearchExpression private constructor(builder: Builder) {
    /**
     * A list of filter objects.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * A list of nested filter objects.
     */
    val nestedFilters: List<NestedFilters>? = builder.nestedFilters
    /**
     * A Boolean operator used to evaluate the search expression. If you want every
     * conditional statement in all lists to be satisfied for the entire search expression to
     * be true, specify And. If only a single conditional statement needs to be
     * true for the entire search expression to be true, specify Or. The default
     * value is And.
     */
    val operator: aws.sdk.kotlin.services.sagemaker.model.BooleanOperator? = builder.operator
    /**
     * A list of search expression objects.
     */
    val subExpressions: List<SearchExpression>? = builder.subExpressions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SearchExpression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchExpression(")
        append("filters=$filters,")
        append("nestedFilters=$nestedFilters,")
        append("operator=$operator,")
        append("subExpressions=$subExpressions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (nestedFilters?.hashCode() ?: 0)
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (subExpressions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchExpression

        if (filters != other.filters) return false
        if (nestedFilters != other.nestedFilters) return false
        if (operator != other.operator) return false
        if (subExpressions != other.subExpressions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SearchExpression = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of filter objects.
         */
        var filters: List<Filter>? = null
        /**
         * A list of nested filter objects.
         */
        var nestedFilters: List<NestedFilters>? = null
        /**
         * A Boolean operator used to evaluate the search expression. If you want every
         * conditional statement in all lists to be satisfied for the entire search expression to
         * be true, specify And. If only a single conditional statement needs to be
         * true for the entire search expression to be true, specify Or. The default
         * value is And.
         */
        var operator: aws.sdk.kotlin.services.sagemaker.model.BooleanOperator? = null
        /**
         * A list of search expression objects.
         */
        var subExpressions: List<SearchExpression>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SearchExpression) : this() {
            this.filters = x.filters
            this.nestedFilters = x.nestedFilters
            this.operator = x.operator
            this.subExpressions = x.subExpressions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SearchExpression = SearchExpression(this)
    }
}
