// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The retry strategy to use when a training job fails due to an
 * InternalServerError. RetryStrategy is specified as part of
 * the CreateTrainingJob and CreateHyperParameterTuningJob
 * requests. You can add the StoppingCondition parameter to the request to
 * limit the training time for the complete job.
 */
class RetryStrategy private constructor(builder: Builder) {
    /**
     * The number of times to retry the job. When the job is retried, it's
     * SecondaryStatus is changed to STARTING.
     */
    val maximumRetryAttempts: kotlin.Int = builder.maximumRetryAttempts

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RetryStrategy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetryStrategy(")
        append("maximumRetryAttempts=$maximumRetryAttempts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumRetryAttempts
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetryStrategy

        if (maximumRetryAttempts != other.maximumRetryAttempts) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RetryStrategy = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of times to retry the job. When the job is retried, it's
         * SecondaryStatus is changed to STARTING.
         */
        var maximumRetryAttempts: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy) : this() {
            this.maximumRetryAttempts = x.maximumRetryAttempts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RetryStrategy = RetryStrategy(this)
    }
}
