// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration for Redshift Dataset Definition input.
 */
class RedshiftDatasetDefinition private constructor(builder: Builder) {
    /**
     * The Redshift cluster Identifier.
     */
    val clusterId: kotlin.String? = builder.clusterId
    /**
     * The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
     */
    val clusterRoleArn: kotlin.String? = builder.clusterRoleArn
    /**
     * The name of the Redshift database used in Redshift query execution.
     */
    val database: kotlin.String? = builder.database
    /**
     * The database user name used in Redshift query execution.
     */
    val dbUser: kotlin.String? = builder.dbUser
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data from a
     * Redshift execution.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The compression used for Redshift query results.
     */
    val outputCompression: aws.sdk.kotlin.services.sagemaker.model.RedshiftResultCompressionType? = builder.outputCompression
    /**
     * The data storage format for Redshift query results.
     */
    val outputFormat: aws.sdk.kotlin.services.sagemaker.model.RedshiftResultFormat? = builder.outputFormat
    /**
     * The location in Amazon S3 where the Redshift query results are stored.
     */
    val outputS3Uri: kotlin.String? = builder.outputS3Uri
    /**
     * The SQL query statements to be executed.
     */
    val queryString: kotlin.String? = builder.queryString

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDatasetDefinition(")
        append("clusterId=$clusterId,")
        append("clusterRoleArn=$clusterRoleArn,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputCompression=$outputCompression,")
        append("outputFormat=$outputFormat,")
        append("outputS3Uri=$outputS3Uri,")
        append("queryString=$queryString)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterId?.hashCode() ?: 0
        result = 31 * result + (clusterRoleArn?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputCompression?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (outputS3Uri?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDatasetDefinition

        if (clusterId != other.clusterId) return false
        if (clusterRoleArn != other.clusterRoleArn) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputCompression != other.outputCompression) return false
        if (outputFormat != other.outputFormat) return false
        if (outputS3Uri != other.outputS3Uri) return false
        if (queryString != other.queryString) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Redshift cluster Identifier.
         */
        var clusterId: kotlin.String? = null
        /**
         * The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
         */
        var clusterRoleArn: kotlin.String? = null
        /**
         * The name of the Redshift database used in Redshift query execution.
         */
        var database: kotlin.String? = null
        /**
         * The database user name used in Redshift query execution.
         */
        var dbUser: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data from a
         * Redshift execution.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The compression used for Redshift query results.
         */
        var outputCompression: aws.sdk.kotlin.services.sagemaker.model.RedshiftResultCompressionType? = null
        /**
         * The data storage format for Redshift query results.
         */
        var outputFormat: aws.sdk.kotlin.services.sagemaker.model.RedshiftResultFormat? = null
        /**
         * The location in Amazon S3 where the Redshift query results are stored.
         */
        var outputS3Uri: kotlin.String? = null
        /**
         * The SQL query statements to be executed.
         */
        var queryString: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition) : this() {
            this.clusterId = x.clusterId
            this.clusterRoleArn = x.clusterRoleArn
            this.database = x.database
            this.dbUser = x.dbUser
            this.kmsKeyId = x.kmsKeyId
            this.outputCompression = x.outputCompression
            this.outputFormat = x.outputFormat
            this.outputS3Uri = x.outputS3Uri
            this.queryString = x.queryString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition = RedshiftDatasetDefinition(this)
    }
}
