// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class QueryLineageRequest private constructor(builder: Builder) {
    /**
     * Associations between lineage entities are directed.  This parameter determines the direction from the
     * StartArn(s) the query will look.
     */
    val direction: aws.sdk.kotlin.services.sagemaker.model.Direction? = builder.direction
    /**
     * A set of filtering parameters that allow you to specify which entities should be returned.
     *
     *
     * Properties - Key-value pairs to match on the lineage entities' properties.
     *
     * LineageTypes - A set of lineage entity types to match on. For example: TrialComponent,
     * Artifact, or Context.
     *
     * CreatedBefore - Filter entities created before this date.
     *
     * ModifiedBefore - Filter entities modified before this date.
     *
     * ModifiedAfter - Filter entities modified after this date.
     */
    val filters: aws.sdk.kotlin.services.sagemaker.model.QueryFilters? = builder.filters
    /**
     * Setting this value to True will retrieve not only the entities of interest but also the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations and
     * lineage entities on the path. Set to False to only return lineage entities that match your query.
     */
    val includeEdges: kotlin.Boolean = builder.includeEdges
    /**
     * The maximum depth in lineage relationships from the StartArns that will be traversed. Depth is a measure of the number
     * of Associations from the StartArn entity to the matched results.
     */
    val maxDepth: kotlin.Int? = builder.maxDepth
    /**
     * Limits the number of vertices in the results. Use the NextToken in a response to to retrieve the next page of results.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Limits the number of vertices in the request. Use the NextToken in a response to to retrieve the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
     */
    val startArns: List<String>? = builder.startArns

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.QueryLineageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryLineageRequest(")
        append("direction=$direction,")
        append("filters=$filters,")
        append("includeEdges=$includeEdges,")
        append("maxDepth=$maxDepth,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startArns=$startArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = direction?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeEdges.hashCode())
        result = 31 * result + (maxDepth ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryLineageRequest

        if (direction != other.direction) return false
        if (filters != other.filters) return false
        if (includeEdges != other.includeEdges) return false
        if (maxDepth != other.maxDepth) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startArns != other.startArns) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.QueryLineageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Associations between lineage entities are directed.  This parameter determines the direction from the
         * StartArn(s) the query will look.
         */
        var direction: aws.sdk.kotlin.services.sagemaker.model.Direction? = null
        /**
         * A set of filtering parameters that allow you to specify which entities should be returned.
         *
         *
         * Properties - Key-value pairs to match on the lineage entities' properties.
         *
         * LineageTypes - A set of lineage entity types to match on. For example: TrialComponent,
         * Artifact, or Context.
         *
         * CreatedBefore - Filter entities created before this date.
         *
         * ModifiedBefore - Filter entities modified before this date.
         *
         * ModifiedAfter - Filter entities modified after this date.
         */
        var filters: aws.sdk.kotlin.services.sagemaker.model.QueryFilters? = null
        /**
         * Setting this value to True will retrieve not only the entities of interest but also the
         * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations and
         * lineage entities on the path. Set to False to only return lineage entities that match your query.
         */
        var includeEdges: kotlin.Boolean = false
        /**
         * The maximum depth in lineage relationships from the StartArns that will be traversed. Depth is a measure of the number
         * of Associations from the StartArn entity to the matched results.
         */
        var maxDepth: kotlin.Int? = null
        /**
         * Limits the number of vertices in the results. Use the NextToken in a response to to retrieve the next page of results.
         */
        var maxResults: kotlin.Int? = null
        /**
         * Limits the number of vertices in the request. Use the NextToken in a response to to retrieve the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
         */
        var startArns: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.QueryLineageRequest) : this() {
            this.direction = x.direction
            this.filters = x.filters
            this.includeEdges = x.includeEdges
            this.maxDepth = x.maxDepth
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startArns = x.startArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.QueryLineageRequest = QueryLineageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.QueryFilters] inside the given [block]
         */
        fun filters(block: aws.sdk.kotlin.services.sagemaker.model.QueryFilters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.sagemaker.model.QueryFilters.invoke(block)
        }
    }
}
