// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The inputs for a processing job. The processing input must specify exactly one of either
 * S3Input or DatasetDefinition types.
 */
class ProcessingInput private constructor(builder: Builder) {
    /**
     * When True, input operations such as data download are managed natively by the
     * processing job application. When False (default), input operations are managed by Amazon SageMaker.
     */
    val appManaged: kotlin.Boolean = builder.appManaged
    /**
     * Configuration for a Dataset Definition input.
     */
    val datasetDefinition: aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition? = builder.datasetDefinition
    /**
     * The name for the processing job input.
     */
    val inputName: kotlin.String? = builder.inputName
    /**
     * Configuration for downloading input data from Amazon S3 into the processing container.
     */
    val s3Input: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input? = builder.s3Input

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingInput(")
        append("appManaged=$appManaged,")
        append("datasetDefinition=$datasetDefinition,")
        append("inputName=$inputName,")
        append("s3Input=$s3Input)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appManaged.hashCode()
        result = 31 * result + (datasetDefinition?.hashCode() ?: 0)
        result = 31 * result + (inputName?.hashCode() ?: 0)
        result = 31 * result + (s3Input?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingInput

        if (appManaged != other.appManaged) return false
        if (datasetDefinition != other.datasetDefinition) return false
        if (inputName != other.inputName) return false
        if (s3Input != other.s3Input) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingInput = Builder(this).apply(block).build()

    class Builder {
        /**
         * When True, input operations such as data download are managed natively by the
         * processing job application. When False (default), input operations are managed by Amazon SageMaker.
         */
        var appManaged: kotlin.Boolean = false
        /**
         * Configuration for a Dataset Definition input.
         */
        var datasetDefinition: aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition? = null
        /**
         * The name for the processing job input.
         */
        var inputName: kotlin.String? = null
        /**
         * Configuration for downloading input data from Amazon S3 into the processing container.
         */
        var s3Input: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingInput) : this() {
            this.appManaged = x.appManaged
            this.datasetDefinition = x.datasetDefinition
            this.inputName = x.inputName
            this.s3Input = x.s3Input
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingInput = ProcessingInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition] inside the given [block]
         */
        fun datasetDefinition(block: aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition.Builder.() -> kotlin.Unit) {
            this.datasetDefinition = aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input] inside the given [block]
         */
        fun s3Input(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input.Builder.() -> kotlin.Unit) {
            this.s3Input = aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input.invoke(block)
        }
    }
}
