// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of a pipeline.
 */
class PipelineSummary private constructor(builder: Builder) {
    /**
     * The creation time of the pipeline.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The last time that a pipeline execution began.
     */
    val lastExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastExecutionTime
    /**
     * The time that the pipeline was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the pipeline.
     */
    val pipelineArn: kotlin.String? = builder.pipelineArn
    /**
     * The description of the pipeline.
     */
    val pipelineDescription: kotlin.String? = builder.pipelineDescription
    /**
     * The display name of the pipeline.
     */
    val pipelineDisplayName: kotlin.String? = builder.pipelineDisplayName
    /**
     * The name of the pipeline.
     */
    val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The Amazon Resource Name (ARN) that the pipeline used to execute.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.PipelineSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineSummary(")
        append("creationTime=$creationTime,")
        append("lastExecutionTime=$lastExecutionTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("pipelineArn=$pipelineArn,")
        append("pipelineDescription=$pipelineDescription,")
        append("pipelineDisplayName=$pipelineDisplayName,")
        append("pipelineName=$pipelineName,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (lastExecutionTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (pipelineArn?.hashCode() ?: 0)
        result = 31 * result + (pipelineDescription?.hashCode() ?: 0)
        result = 31 * result + (pipelineDisplayName?.hashCode() ?: 0)
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineSummary

        if (creationTime != other.creationTime) return false
        if (lastExecutionTime != other.lastExecutionTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (pipelineArn != other.pipelineArn) return false
        if (pipelineDescription != other.pipelineDescription) return false
        if (pipelineDisplayName != other.pipelineDisplayName) return false
        if (pipelineName != other.pipelineName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.PipelineSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation time of the pipeline.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time that a pipeline execution began.
         */
        var lastExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the pipeline was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the pipeline.
         */
        var pipelineArn: kotlin.String? = null
        /**
         * The description of the pipeline.
         */
        var pipelineDescription: kotlin.String? = null
        /**
         * The display name of the pipeline.
         */
        var pipelineDisplayName: kotlin.String? = null
        /**
         * The name of the pipeline.
         */
        var pipelineName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that the pipeline used to execute.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.PipelineSummary) : this() {
            this.creationTime = x.creationTime
            this.lastExecutionTime = x.lastExecutionTime
            this.lastModifiedTime = x.lastModifiedTime
            this.pipelineArn = x.pipelineArn
            this.pipelineDescription = x.pipelineDescription
            this.pipelineDisplayName = x.pipelineDisplayName
            this.pipelineName = x.pipelineName
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.PipelineSummary = PipelineSummary(this)
    }
}
