// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The networking configuration for the monitoring job.
 */
class MonitoringNetworkConfig private constructor(builder: Builder) {
    /**
     * Whether to encrypt all communications between the instances used for the monitoring
     * jobs. Choose True to encrypt communications. Encryption provides greater
     * security for distributed jobs, but the processing might take longer.
     */
    val enableInterContainerTrafficEncryption: kotlin.Boolean = builder.enableInterContainerTrafficEncryption
    /**
     * Whether to allow inbound and outbound network calls to and from the containers used for
     * the monitoring job.
     */
    val enableNetworkIsolation: kotlin.Boolean = builder.enableNetworkIsolation
    /**
     * Specifies a VPC that your training jobs and hosted models have access to. Control
     * access to and from your training and model containers by configuring the VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
     * by Using an Amazon Virtual Private Cloud.
     */
    val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringNetworkConfig(")
        append("enableInterContainerTrafficEncryption=$enableInterContainerTrafficEncryption,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableInterContainerTrafficEncryption.hashCode()
        result = 31 * result + (enableNetworkIsolation.hashCode())
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringNetworkConfig

        if (enableInterContainerTrafficEncryption != other.enableInterContainerTrafficEncryption) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether to encrypt all communications between the instances used for the monitoring
         * jobs. Choose True to encrypt communications. Encryption provides greater
         * security for distributed jobs, but the processing might take longer.
         */
        var enableInterContainerTrafficEncryption: kotlin.Boolean = false
        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for
         * the monitoring job.
         */
        var enableNetworkIsolation: kotlin.Boolean = false
        /**
         * Specifies a VPC that your training jobs and hosted models have access to. Control
         * access to and from your training and model containers by configuring the VPC. For more
         * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
         * by Using an Amazon Virtual Private Cloud.
         */
        var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig) : this() {
            this.enableInterContainerTrafficEncryption = x.enableInterContainerTrafficEncryption
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig = MonitoringNetworkConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }
    }
}
