// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Container image configuration object for the monitoring job.
 */
class MonitoringAppSpecification private constructor(builder: Builder) {
    /**
     * An array of arguments for the container used to run the monitoring job.
     */
    val containerArguments: List<String>? = builder.containerArguments
    /**
     * Specifies the entrypoint for a container used to run the monitoring job.
     */
    val containerEntrypoint: List<String>? = builder.containerEntrypoint
    /**
     * The container image to be run by the monitoring job.
     */
    val imageUri: kotlin.String? = builder.imageUri
    /**
     * An Amazon S3 URI to a script that is called after analysis has been performed.
     * Applicable only for the built-in (first party) containers.
     */
    val postAnalyticsProcessorSourceUri: kotlin.String? = builder.postAnalyticsProcessorSourceUri
    /**
     * An Amazon S3 URI to a script that is called per row prior to running analysis. It can
     * base64 decode the payload and convert it into a flatted json so that the built-in container
     * can use the converted data. Applicable only for the built-in (first party)
     * containers.
     */
    val recordPreprocessorSourceUri: kotlin.String? = builder.recordPreprocessorSourceUri

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringAppSpecification(")
        append("containerArguments=$containerArguments,")
        append("containerEntrypoint=$containerEntrypoint,")
        append("imageUri=$imageUri,")
        append("postAnalyticsProcessorSourceUri=$postAnalyticsProcessorSourceUri,")
        append("recordPreprocessorSourceUri=$recordPreprocessorSourceUri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerArguments?.hashCode() ?: 0
        result = 31 * result + (containerEntrypoint?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        result = 31 * result + (postAnalyticsProcessorSourceUri?.hashCode() ?: 0)
        result = 31 * result + (recordPreprocessorSourceUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringAppSpecification

        if (containerArguments != other.containerArguments) return false
        if (containerEntrypoint != other.containerEntrypoint) return false
        if (imageUri != other.imageUri) return false
        if (postAnalyticsProcessorSourceUri != other.postAnalyticsProcessorSourceUri) return false
        if (recordPreprocessorSourceUri != other.recordPreprocessorSourceUri) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of arguments for the container used to run the monitoring job.
         */
        var containerArguments: List<String>? = null
        /**
         * Specifies the entrypoint for a container used to run the monitoring job.
         */
        var containerEntrypoint: List<String>? = null
        /**
         * The container image to be run by the monitoring job.
         */
        var imageUri: kotlin.String? = null
        /**
         * An Amazon S3 URI to a script that is called after analysis has been performed.
         * Applicable only for the built-in (first party) containers.
         */
        var postAnalyticsProcessorSourceUri: kotlin.String? = null
        /**
         * An Amazon S3 URI to a script that is called per row prior to running analysis. It can
         * base64 decode the payload and convert it into a flatted json so that the built-in container
         * can use the converted data. Applicable only for the built-in (first party)
         * containers.
         */
        var recordPreprocessorSourceUri: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification) : this() {
            this.containerArguments = x.containerArguments
            this.containerEntrypoint = x.containerEntrypoint
            this.imageUri = x.imageUri
            this.postAnalyticsProcessorSourceUri = x.postAnalyticsProcessorSourceUri
            this.recordPreprocessorSourceUri = x.recordPreprocessorSourceUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification = MonitoringAppSpecification(this)
    }
}
