// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A group of versioned models in the model registry.
 */
class ModelPackageGroup private constructor(builder: Builder) {
    /**
     * Information about the user who created or modified an experiment, trial, trial
     * component, lineage group, or project.
     */
    val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * The time that the model group was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the model group.
     */
    val modelPackageGroupArn: kotlin.String? = builder.modelPackageGroupArn
    /**
     * The description for the model group.
     */
    val modelPackageGroupDescription: kotlin.String? = builder.modelPackageGroupDescription
    /**
     * The name of the model group.
     */
    val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The status of the model group. This can be one of the following values.
     *
     *
     *
     * PENDING - The model group is pending being created.
     *
     *
     * IN_PROGRESS - The model group is in the process of being
     * created.
     *
     *
     * COMPLETED - The model group was successfully created.
     *
     *
     * FAILED - The model group failed.
     *
     *
     * DELETING - The model group is in the process of being deleted.
     *
     *
     * DELETE_FAILED - SageMaker failed to delete the model group.
     */
    val modelPackageGroupStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroupStatus? = builder.modelPackageGroupStatus
    /**
     * A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * resources in the Amazon Web Services General Reference Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackageGroup(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("modelPackageGroupArn=$modelPackageGroupArn,")
        append("modelPackageGroupDescription=$modelPackageGroupDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageGroupStatus=$modelPackageGroupStatus,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupArn?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackageGroup

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (modelPackageGroupArn != other.modelPackageGroupArn) return false
        if (modelPackageGroupDescription != other.modelPackageGroupDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageGroupStatus != other.modelPackageGroupStatus) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the user who created or modified an experiment, trial, trial
         * component, lineage group, or project.
         */
        var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The time that the model group was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model group.
         */
        var modelPackageGroupArn: kotlin.String? = null
        /**
         * The description for the model group.
         */
        var modelPackageGroupDescription: kotlin.String? = null
        /**
         * The name of the model group.
         */
        var modelPackageGroupName: kotlin.String? = null
        /**
         * The status of the model group. This can be one of the following values.
         *
         *
         *
         * PENDING - The model group is pending being created.
         *
         *
         * IN_PROGRESS - The model group is in the process of being
         * created.
         *
         *
         * COMPLETED - The model group was successfully created.
         *
         *
         * FAILED - The model group failed.
         *
         *
         * DELETING - The model group is in the process of being deleted.
         *
         *
         * DELETE_FAILED - SageMaker failed to delete the model group.
         */
        var modelPackageGroupStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroupStatus? = null
        /**
         * A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources in the Amazon Web Services General Reference Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroup) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.modelPackageGroupArn = x.modelPackageGroupArn
            this.modelPackageGroupDescription = x.modelPackageGroupDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageGroupStatus = x.modelPackageGroupStatus
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroup = ModelPackageGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }
    }
}
