// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A versioned model that can be deployed for SageMaker inference.
 */
class ModelPackage private constructor(builder: Builder) {
    /**
     * An array of additional Inference Specification objects.
     */
    val additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = builder.additionalInferenceSpecifications
    /**
     * A description provided when the model approval is set.
     */
    val approvalDescription: kotlin.String? = builder.approvalDescription
    /**
     * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
     * information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
     * Algorithm or Model Package on Amazon Web Services Marketplace.
     */
    val certifyForMarketplace: kotlin.Boolean = builder.certifyForMarketplace
    /**
     * Information about the user who created or modified an experiment, trial, trial
     * component, lineage group, or project.
     */
    val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * The time that the model package was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The metadata properties for the model package.
     */
    val customerMetadataProperties: Map<String, String>? = builder.customerMetadataProperties
    /**
     * The machine learning domain of your model package and its components. Common
     * machine learning domains include computer vision and natural language processing.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     */
    val driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = builder.driftCheckBaselines
    /**
     * Defines how to perform inference generation after a training job is run.
     */
    val inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = builder.inferenceSpecification
    /**
     * Information about the user who created or modified an experiment, trial, trial
     * component, lineage group, or project.
     */
    val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * The last time the model package was modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * The approval status of the model. This can be one of the following values.
     *
     *
     *
     * APPROVED - The model is approved
     *
     *
     * REJECTED - The model is rejected.
     *
     *
     * PENDING_MANUAL_APPROVAL - The model is waiting for manual
     * approval.
     */
    val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * Metrics for the model.
     */
    val modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = builder.modelMetrics
    /**
     * The Amazon Resource Name (ARN) of the model package.
     */
    val modelPackageArn: kotlin.String? = builder.modelPackageArn
    /**
     * The description of the model package.
     */
    val modelPackageDescription: kotlin.String? = builder.modelPackageDescription
    /**
     * The model group to which the model belongs.
     */
    val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The name of the model.
     */
    val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * The status of the model package. This can be one of the following values.
     *
     *
     *
     * PENDING - The model package is pending being created.
     *
     *
     * IN_PROGRESS - The model package is in the process of being
     * created.
     *
     *
     * COMPLETED - The model package was successfully created.
     *
     *
     * FAILED - The model package failed.
     *
     *
     * DELETING - The model package is in the process of being deleted.
     */
    val modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = builder.modelPackageStatus
    /**
     * Specifies the validation and image scan statuses of the model package.
     */
    val modelPackageStatusDetails: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails? = builder.modelPackageStatusDetails
    /**
     * The version number of a versioned model.
     */
    val modelPackageVersion: kotlin.Int? = builder.modelPackageVersion
    /**
     * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
     * a single gzip compressed tar archive (.tar.gz suffix).
     */
    val samplePayloadUrl: kotlin.String? = builder.samplePayloadUrl
    /**
     * A list of algorithms that were used to create a model package.
     */
    val sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = builder.sourceAlgorithmSpecification
    /**
     * A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * resources in the Amazon Web Services General Reference Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The machine learning task your model package accomplishes. Common machine
     * learning tasks include object detection and image classification.
     */
    val task: kotlin.String? = builder.task
    /**
     * Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.
     */
    val validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = builder.validationSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackage(")
        append("additionalInferenceSpecifications=$additionalInferenceSpecifications,")
        append("approvalDescription=$approvalDescription,")
        append("certifyForMarketplace=$certifyForMarketplace,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("customerMetadataProperties=$customerMetadataProperties,")
        append("domain=$domain,")
        append("driftCheckBaselines=$driftCheckBaselines,")
        append("inferenceSpecification=$inferenceSpecification,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("metadataProperties=$metadataProperties,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelMetrics=$modelMetrics,")
        append("modelPackageArn=$modelPackageArn,")
        append("modelPackageDescription=$modelPackageDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageName=$modelPackageName,")
        append("modelPackageStatus=$modelPackageStatus,")
        append("modelPackageStatusDetails=$modelPackageStatusDetails,")
        append("modelPackageVersion=$modelPackageVersion,")
        append("samplePayloadUrl=$samplePayloadUrl,")
        append("sourceAlgorithmSpecification=$sourceAlgorithmSpecification,")
        append("tags=$tags,")
        append("task=$task,")
        append("validationSpecification=$validationSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInferenceSpecifications?.hashCode() ?: 0
        result = 31 * result + (approvalDescription?.hashCode() ?: 0)
        result = 31 * result + (certifyForMarketplace.hashCode())
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (customerMetadataProperties?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (driftCheckBaselines?.hashCode() ?: 0)
        result = 31 * result + (inferenceSpecification?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelMetrics?.hashCode() ?: 0)
        result = 31 * result + (modelPackageArn?.hashCode() ?: 0)
        result = 31 * result + (modelPackageDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageStatus?.hashCode() ?: 0)
        result = 31 * result + (modelPackageStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersion ?: 0)
        result = 31 * result + (samplePayloadUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceAlgorithmSpecification?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (validationSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackage

        if (additionalInferenceSpecifications != other.additionalInferenceSpecifications) return false
        if (approvalDescription != other.approvalDescription) return false
        if (certifyForMarketplace != other.certifyForMarketplace) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (customerMetadataProperties != other.customerMetadataProperties) return false
        if (domain != other.domain) return false
        if (driftCheckBaselines != other.driftCheckBaselines) return false
        if (inferenceSpecification != other.inferenceSpecification) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (metadataProperties != other.metadataProperties) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelMetrics != other.modelMetrics) return false
        if (modelPackageArn != other.modelPackageArn) return false
        if (modelPackageDescription != other.modelPackageDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageName != other.modelPackageName) return false
        if (modelPackageStatus != other.modelPackageStatus) return false
        if (modelPackageStatusDetails != other.modelPackageStatusDetails) return false
        if (modelPackageVersion != other.modelPackageVersion) return false
        if (samplePayloadUrl != other.samplePayloadUrl) return false
        if (sourceAlgorithmSpecification != other.sourceAlgorithmSpecification) return false
        if (tags != other.tags) return false
        if (task != other.task) return false
        if (validationSpecification != other.validationSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of additional Inference Specification objects.
         */
        var additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = null
        /**
         * A description provided when the model approval is set.
         */
        var approvalDescription: kotlin.String? = null
        /**
         * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
         * information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
         * Algorithm or Model Package on Amazon Web Services Marketplace.
         */
        var certifyForMarketplace: kotlin.Boolean = false
        /**
         * Information about the user who created or modified an experiment, trial, trial
         * component, lineage group, or project.
         */
        var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The time that the model package was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metadata properties for the model package.
         */
        var customerMetadataProperties: Map<String, String>? = null
        /**
         * The machine learning domain of your model package and its components. Common
         * machine learning domains include computer vision and natural language processing.
         */
        var domain: kotlin.String? = null
        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         */
        var driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = null
        /**
         * Defines how to perform inference generation after a training job is run.
         */
        var inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial
         * component, lineage group, or project.
         */
        var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The last time the model package was modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * The approval status of the model. This can be one of the following values.
         *
         *
         *
         * APPROVED - The model is approved
         *
         *
         * REJECTED - The model is rejected.
         *
         *
         * PENDING_MANUAL_APPROVAL - The model is waiting for manual
         * approval.
         */
        var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * Metrics for the model.
         */
        var modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = null
        /**
         * The Amazon Resource Name (ARN) of the model package.
         */
        var modelPackageArn: kotlin.String? = null
        /**
         * The description of the model package.
         */
        var modelPackageDescription: kotlin.String? = null
        /**
         * The model group to which the model belongs.
         */
        var modelPackageGroupName: kotlin.String? = null
        /**
         * The name of the model.
         */
        var modelPackageName: kotlin.String? = null
        /**
         * The status of the model package. This can be one of the following values.
         *
         *
         *
         * PENDING - The model package is pending being created.
         *
         *
         * IN_PROGRESS - The model package is in the process of being
         * created.
         *
         *
         * COMPLETED - The model package was successfully created.
         *
         *
         * FAILED - The model package failed.
         *
         *
         * DELETING - The model package is in the process of being deleted.
         */
        var modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = null
        /**
         * Specifies the validation and image scan statuses of the model package.
         */
        var modelPackageStatusDetails: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails? = null
        /**
         * The version number of a versioned model.
         */
        var modelPackageVersion: kotlin.Int? = null
        /**
         * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
         * a single gzip compressed tar archive (.tar.gz suffix).
         */
        var samplePayloadUrl: kotlin.String? = null
        /**
         * A list of algorithms that were used to create a model package.
         */
        var sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = null
        /**
         * A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources in the Amazon Web Services General Reference Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The machine learning task your model package accomplishes. Common machine
         * learning tasks include object detection and image classification.
         */
        var task: kotlin.String? = null
        /**
         * Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.
         */
        var validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackage) : this() {
            this.additionalInferenceSpecifications = x.additionalInferenceSpecifications
            this.approvalDescription = x.approvalDescription
            this.certifyForMarketplace = x.certifyForMarketplace
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.customerMetadataProperties = x.customerMetadataProperties
            this.domain = x.domain
            this.driftCheckBaselines = x.driftCheckBaselines
            this.inferenceSpecification = x.inferenceSpecification
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.metadataProperties = x.metadataProperties
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelMetrics = x.modelMetrics
            this.modelPackageArn = x.modelPackageArn
            this.modelPackageDescription = x.modelPackageDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageName = x.modelPackageName
            this.modelPackageStatus = x.modelPackageStatus
            this.modelPackageStatusDetails = x.modelPackageStatusDetails
            this.modelPackageVersion = x.modelPackageVersion
            this.samplePayloadUrl = x.samplePayloadUrl
            this.sourceAlgorithmSpecification = x.sourceAlgorithmSpecification
            this.tags = x.tags
            this.task = x.task
            this.validationSpecification = x.validationSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = ModelPackage(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines] inside the given [block]
         */
        fun driftCheckBaselines(block: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.Builder.() -> kotlin.Unit) {
            this.driftCheckBaselines = aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification] inside the given [block]
         */
        fun inferenceSpecification(block: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.Builder.() -> kotlin.Unit) {
            this.inferenceSpecification = aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelMetrics] inside the given [block]
         */
        fun modelMetrics(block: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.Builder.() -> kotlin.Unit) {
            this.modelMetrics = aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails] inside the given [block]
         */
        fun modelPackageStatusDetails(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails.Builder.() -> kotlin.Unit) {
            this.modelPackageStatusDetails = aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification] inside the given [block]
         */
        fun sourceAlgorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.sourceAlgorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification] inside the given [block]
         */
        fun validationSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.Builder.() -> kotlin.Unit) {
            this.validationSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.invoke(block)
        }
    }
}
