// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class ListModelPackagesRequest private constructor(builder: Builder) {
    /**
     * A filter that returns only model packages created after the specified time
     * (timestamp).
     */
    val creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeAfter
    /**
     * A filter that returns only model packages created before the specified time
     * (timestamp).
     */
    val creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeBefore
    /**
     * The maximum number of model packages to return in the response.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A filter that returns only the model packages with the specified approval
     * status.
     */
    val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * A filter that returns only model versions that belong to the specified model group.
     */
    val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * A filter that returns only the model packages of the specified type. This can be one
     * of the following values.
     *
     *
     *
     * UNVERSIONED - List only unversioined models.
     * This is the default value if no ModelPackageType is specified.
     *
     *
     * VERSIONED - List only versioned models.
     *
     *
     * BOTH - List both versioned and unversioned models.
     */
    val modelPackageType: aws.sdk.kotlin.services.sagemaker.model.ModelPackageType? = builder.modelPackageType
    /**
     * A string in the model package name. This filter returns only model packages whose name
     * contains the specified string.
     */
    val nameContains: kotlin.String? = builder.nameContains
    /**
     * If the response to a previous ListModelPackages request was truncated,
     * the response includes a NextToken. To retrieve the next set of model
     * packages, use the token in the next request.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The parameter by which to sort the results. The default is
     * CreationTime.
     */
    val sortBy: aws.sdk.kotlin.services.sagemaker.model.ModelPackageSortBy? = builder.sortBy
    /**
     * The sort order for the results. The default is Ascending.
     */
    val sortOrder: aws.sdk.kotlin.services.sagemaker.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ListModelPackagesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListModelPackagesRequest(")
        append("creationTimeAfter=$creationTimeAfter,")
        append("creationTimeBefore=$creationTimeBefore,")
        append("maxResults=$maxResults,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageType=$modelPackageType,")
        append("nameContains=$nameContains,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimeAfter?.hashCode() ?: 0
        result = 31 * result + (creationTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageType?.hashCode() ?: 0)
        result = 31 * result + (nameContains?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListModelPackagesRequest

        if (creationTimeAfter != other.creationTimeAfter) return false
        if (creationTimeBefore != other.creationTimeBefore) return false
        if (maxResults != other.maxResults) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageType != other.modelPackageType) return false
        if (nameContains != other.nameContains) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ListModelPackagesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A filter that returns only model packages created after the specified time
         * (timestamp).
         */
        var creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A filter that returns only model packages created before the specified time
         * (timestamp).
         */
        var creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of model packages to return in the response.
         */
        var maxResults: kotlin.Int? = null
        /**
         * A filter that returns only the model packages with the specified approval
         * status.
         */
        var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * A filter that returns only model versions that belong to the specified model group.
         */
        var modelPackageGroupName: kotlin.String? = null
        /**
         * A filter that returns only the model packages of the specified type. This can be one
         * of the following values.
         *
         *
         *
         * UNVERSIONED - List only unversioined models.
         * This is the default value if no ModelPackageType is specified.
         *
         *
         * VERSIONED - List only versioned models.
         *
         *
         * BOTH - List both versioned and unversioned models.
         */
        var modelPackageType: aws.sdk.kotlin.services.sagemaker.model.ModelPackageType? = null
        /**
         * A string in the model package name. This filter returns only model packages whose name
         * contains the specified string.
         */
        var nameContains: kotlin.String? = null
        /**
         * If the response to a previous ListModelPackages request was truncated,
         * the response includes a NextToken. To retrieve the next set of model
         * packages, use the token in the next request.
         */
        var nextToken: kotlin.String? = null
        /**
         * The parameter by which to sort the results. The default is
         * CreationTime.
         */
        var sortBy: aws.sdk.kotlin.services.sagemaker.model.ModelPackageSortBy? = null
        /**
         * The sort order for the results. The default is Ascending.
         */
        var sortOrder: aws.sdk.kotlin.services.sagemaker.model.SortOrder? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ListModelPackagesRequest) : this() {
            this.creationTimeAfter = x.creationTimeAfter
            this.creationTimeBefore = x.creationTimeBefore
            this.maxResults = x.maxResults
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageType = x.modelPackageType
            this.nameContains = x.nameContains
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ListModelPackagesRequest = ListModelPackagesRequest(this)
    }
}
