// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A set of conditions for stopping a labeling job. If any of the conditions are met, the
 * job is automatically stopped. You can use these conditions to control the cost of data
 * labeling.
 *
 * Labeling jobs fail after 30 days with an appropriate client error message.
 */
class LabelingJobStoppingConditions private constructor(builder: Builder) {
    /**
     * The maximum number of objects that can be labeled by human workers.
     */
    val maxHumanLabeledObjectCount: kotlin.Int? = builder.maxHumanLabeledObjectCount
    /**
     * The maximum number of input data objects that should be labeled.
     */
    val maxPercentageOfInputDatasetLabeled: kotlin.Int? = builder.maxPercentageOfInputDatasetLabeled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobStoppingConditions(")
        append("maxHumanLabeledObjectCount=$maxHumanLabeledObjectCount,")
        append("maxPercentageOfInputDatasetLabeled=$maxPercentageOfInputDatasetLabeled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxHumanLabeledObjectCount ?: 0
        result = 31 * result + (maxPercentageOfInputDatasetLabeled ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobStoppingConditions

        if (maxHumanLabeledObjectCount != other.maxHumanLabeledObjectCount) return false
        if (maxPercentageOfInputDatasetLabeled != other.maxPercentageOfInputDatasetLabeled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of objects that can be labeled by human workers.
         */
        var maxHumanLabeledObjectCount: kotlin.Int? = null
        /**
         * The maximum number of input data objects that should be labeled.
         */
        var maxPercentageOfInputDatasetLabeled: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions) : this() {
            this.maxHumanLabeledObjectCount = x.maxHumanLabeledObjectCount
            this.maxPercentageOfInputDatasetLabeled = x.maxPercentageOfInputDatasetLabeled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions = LabelingJobStoppingConditions(this)
    }
}
