// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configures a hyperparameter tuning job.
 */
class HyperParameterTuningJobConfig private constructor(builder: Builder) {
    /**
     * The HyperParameterTuningJobObjective object that specifies the
     * objective
     * metric for this tuning job.
     */
    val hyperParameterTuningJobObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = builder.hyperParameterTuningJobObjective
    /**
     * The ParameterRanges object that specifies the ranges of
     * hyperparameters
     * that this tuning job searches.
     */
    val parameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = builder.parameterRanges
    /**
     * The ResourceLimits object that specifies the
     * maximum
     * number of training jobs and parallel training jobs for this tuning
     * job.
     */
    val resourceLimits: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits? = builder.resourceLimits
    /**
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values
     * to use for the training job it launches. To use the Bayesian search strategy, set this
     * to Bayesian. To randomly search, set it to Random. For
     * information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works.
     */
    val strategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyType? = builder.strategy
    /**
     * Specifies whether to use early stopping for training jobs launched by the
     * hyperparameter tuning job. This can be one of the following values (the default value is
     * OFF):
     *
     * OFF
     *
     * Training jobs launched by the hyperparameter tuning job do not use early
     * stopping.
     *
     * AUTO
     *
     * Amazon SageMaker stops training jobs launched by the hyperparameter tuning job when
     * they are unlikely to perform better than previously completed training jobs.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training Jobs Early.
     */
    val trainingJobEarlyStoppingType: aws.sdk.kotlin.services.sagemaker.model.TrainingJobEarlyStoppingType? = builder.trainingJobEarlyStoppingType
    /**
     * The tuning job's completion criteria.
     */
    val tuningJobCompletionCriteria: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria? = builder.tuningJobCompletionCriteria

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningJobConfig(")
        append("hyperParameterTuningJobObjective=$hyperParameterTuningJobObjective,")
        append("parameterRanges=$parameterRanges,")
        append("resourceLimits=$resourceLimits,")
        append("strategy=$strategy,")
        append("trainingJobEarlyStoppingType=$trainingJobEarlyStoppingType,")
        append("tuningJobCompletionCriteria=$tuningJobCompletionCriteria)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hyperParameterTuningJobObjective?.hashCode() ?: 0
        result = 31 * result + (parameterRanges?.hashCode() ?: 0)
        result = 31 * result + (resourceLimits?.hashCode() ?: 0)
        result = 31 * result + (strategy?.hashCode() ?: 0)
        result = 31 * result + (trainingJobEarlyStoppingType?.hashCode() ?: 0)
        result = 31 * result + (tuningJobCompletionCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningJobConfig

        if (hyperParameterTuningJobObjective != other.hyperParameterTuningJobObjective) return false
        if (parameterRanges != other.parameterRanges) return false
        if (resourceLimits != other.resourceLimits) return false
        if (strategy != other.strategy) return false
        if (trainingJobEarlyStoppingType != other.trainingJobEarlyStoppingType) return false
        if (tuningJobCompletionCriteria != other.tuningJobCompletionCriteria) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The HyperParameterTuningJobObjective object that specifies the
         * objective
         * metric for this tuning job.
         */
        var hyperParameterTuningJobObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = null
        /**
         * The ParameterRanges object that specifies the ranges of
         * hyperparameters
         * that this tuning job searches.
         */
        var parameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = null
        /**
         * The ResourceLimits object that specifies the
         * maximum
         * number of training jobs and parallel training jobs for this tuning
         * job.
         */
        var resourceLimits: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits? = null
        /**
         * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values
         * to use for the training job it launches. To use the Bayesian search strategy, set this
         * to Bayesian. To randomly search, set it to Random. For
         * information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
         * Hyperparameter Tuning Works.
         */
        var strategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyType? = null
        /**
         * Specifies whether to use early stopping for training jobs launched by the
         * hyperparameter tuning job. This can be one of the following values (the default value is
         * OFF):
         *
         * OFF
         *
         * Training jobs launched by the hyperparameter tuning job do not use early
         * stopping.
         *
         * AUTO
         *
         * Amazon SageMaker stops training jobs launched by the hyperparameter tuning job when
         * they are unlikely to perform better than previously completed training jobs.
         * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training Jobs Early.
         */
        var trainingJobEarlyStoppingType: aws.sdk.kotlin.services.sagemaker.model.TrainingJobEarlyStoppingType? = null
        /**
         * The tuning job's completion criteria.
         */
        var tuningJobCompletionCriteria: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig) : this() {
            this.hyperParameterTuningJobObjective = x.hyperParameterTuningJobObjective
            this.parameterRanges = x.parameterRanges
            this.resourceLimits = x.resourceLimits
            this.strategy = x.strategy
            this.trainingJobEarlyStoppingType = x.trainingJobEarlyStoppingType
            this.tuningJobCompletionCriteria = x.tuningJobCompletionCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = HyperParameterTuningJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective] inside the given [block]
         */
        fun hyperParameterTuningJobObjective(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobObjective = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ParameterRanges] inside the given [block]
         */
        fun parameterRanges(block: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.Builder.() -> kotlin.Unit) {
            this.parameterRanges = aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceLimits] inside the given [block]
         */
        fun resourceLimits(block: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits.Builder.() -> kotlin.Unit) {
            this.resourceLimits = aws.sdk.kotlin.services.sagemaker.model.ResourceLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria] inside the given [block]
         */
        fun tuningJobCompletionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.tuningJobCompletionCriteria = aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria.invoke(block)
        }
    }
}
