// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies
 * which
 * training algorithm to use for training jobs that a hyperparameter
 * tuning job launches and the metrics to monitor.
 */
class HyperParameterAlgorithmSpecification private constructor(builder: Builder) {
    /**
     * The name of the resource algorithm to use for the hyperparameter tuning job. If you
     * specify a value for this parameter, do not specify a value for
     * TrainingImage.
     */
    val algorithmName: kotlin.String? = builder.algorithmName
    /**
     * An array of MetricDefinition objects that specify the
     * metrics
     * that the algorithm emits.
     */
    val metricDefinitions: List<MetricDefinition>? = builder.metricDefinitions
    /**
     * The registry path of the Docker image that contains the training algorithm. For
     * information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms
     * Provided by Amazon SageMaker: Common Parameters. Amazon SageMaker supports both
     * registry/repository&#91;:tag&#93; and registry/repository&#91;@digest&#93;
     * image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
     * SageMaker.
     */
    val trainingImage: kotlin.String? = builder.trainingImage
    /**
     * The training input mode that the algorithm supports. For more information about input modes, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms.
     *
     *
     * Pipe mode
     *
     * If an algorithm supports Pipe mode, Amazon SageMaker streams data directly
     * from Amazon S3 to the container.
     *
     *
     * File mode
     *
     * If an algorithm supports File mode, SageMaker
     * downloads the training data from S3 to the provisioned ML storage volume, and mounts the
     * directory to the Docker volume for the training container.
     * You must provision the ML storage volume with sufficient capacity
     * to accommodate the data downloaded from S3. In addition to the training data, the ML
     * storage volume also stores the output model. The algorithm container uses the ML storage
     * volume to also store intermediate information, if any.
     * For distributed algorithms, training data is distributed uniformly.
     * Your training duration is predictable if the input data objects sizes are
     * approximately the same. SageMaker does not split the files any further for model training.
     * If the object sizes are skewed, training won't be optimal as the data distribution is also
     * skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in
     * training.
     *
     *
     * FastFile mode
     *
     * If an algorithm supports FastFile mode, SageMaker streams data directly
     * from S3 to the container with no code changes, and provides file system access to
     * the data. Users can author their training script to interact with these files as if
     * they were stored on disk.
     *
     * FastFile mode works best when the data is read sequentially.
     * Augmented manifest files aren't supported.
     * The startup time is lower when there are fewer files in the S3 bucket provided.
     */
    val trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = builder.trainingInputMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterAlgorithmSpecification(")
        append("algorithmName=$algorithmName,")
        append("metricDefinitions=$metricDefinitions,")
        append("trainingImage=$trainingImage,")
        append("trainingInputMode=$trainingInputMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmName?.hashCode() ?: 0
        result = 31 * result + (metricDefinitions?.hashCode() ?: 0)
        result = 31 * result + (trainingImage?.hashCode() ?: 0)
        result = 31 * result + (trainingInputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterAlgorithmSpecification

        if (algorithmName != other.algorithmName) return false
        if (metricDefinitions != other.metricDefinitions) return false
        if (trainingImage != other.trainingImage) return false
        if (trainingInputMode != other.trainingInputMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the resource algorithm to use for the hyperparameter tuning job. If you
         * specify a value for this parameter, do not specify a value for
         * TrainingImage.
         */
        var algorithmName: kotlin.String? = null
        /**
         * An array of MetricDefinition objects that specify the
         * metrics
         * that the algorithm emits.
         */
        var metricDefinitions: List<MetricDefinition>? = null
        /**
         * The registry path of the Docker image that contains the training algorithm. For
         * information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms
         * Provided by Amazon SageMaker: Common Parameters. Amazon SageMaker supports both
         * registry/repository&#91;:tag&#93; and registry/repository&#91;@digest&#93;
         * image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
         * SageMaker.
         */
        var trainingImage: kotlin.String? = null
        /**
         * The training input mode that the algorithm supports. For more information about input modes, see
         * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms.
         *
         *
         * Pipe mode
         *
         * If an algorithm supports Pipe mode, Amazon SageMaker streams data directly
         * from Amazon S3 to the container.
         *
         *
         * File mode
         *
         * If an algorithm supports File mode, SageMaker
         * downloads the training data from S3 to the provisioned ML storage volume, and mounts the
         * directory to the Docker volume for the training container.
         * You must provision the ML storage volume with sufficient capacity
         * to accommodate the data downloaded from S3. In addition to the training data, the ML
         * storage volume also stores the output model. The algorithm container uses the ML storage
         * volume to also store intermediate information, if any.
         * For distributed algorithms, training data is distributed uniformly.
         * Your training duration is predictable if the input data objects sizes are
         * approximately the same. SageMaker does not split the files any further for model training.
         * If the object sizes are skewed, training won't be optimal as the data distribution is also
         * skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in
         * training.
         *
         *
         * FastFile mode
         *
         * If an algorithm supports FastFile mode, SageMaker streams data directly
         * from S3 to the container with no code changes, and provides file system access to
         * the data. Users can author their training script to interact with these files as if
         * they were stored on disk.
         *
         * FastFile mode works best when the data is read sequentially.
         * Augmented manifest files aren't supported.
         * The startup time is lower when there are fewer files in the S3 bucket provided.
         */
        var trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification) : this() {
            this.algorithmName = x.algorithmName
            this.metricDefinitions = x.metricDefinitions
            this.trainingImage = x.trainingImage
            this.trainingInputMode = x.trainingInputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification = HyperParameterAlgorithmSpecification(this)
    }
}
