// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeProcessingJobResponse private constructor(builder: Builder) {
    /**
     * Configures the processing job to run a specified container image.
     */
    val appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = builder.appSpecification
    /**
     * The ARN of an AutoML job associated with this processing job.
     */
    val autoMlJobArn: kotlin.String? = builder.autoMlJobArn
    /**
     * The time at which the processing job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The environment variables set in the Docker container.
     */
    val environment: Map<String, String>? = builder.environment
    /**
     * An optional string, up to one KB in size, that contains metadata from the processing
     * container when the processing job exits.
     */
    val exitMessage: kotlin.String? = builder.exitMessage
    /**
     * The configuration information used to create an experiment.
     */
    val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * A string, up to one KB in size, that contains the reason a processing job failed, if
     * it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The time at which the processing job was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The ARN of a monitoring schedule for an endpoint associated with this processing
     * job.
     */
    val monitoringScheduleArn: kotlin.String? = builder.monitoringScheduleArn
    /**
     * Networking options for a processing job.
     */
    val networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = builder.networkConfig
    /**
     * The time at which the processing job completed.
     */
    val processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.processingEndTime
    /**
     * The inputs for a processing job.
     */
    val processingInputs: List<ProcessingInput>? = builder.processingInputs
    /**
     * The Amazon Resource Name (ARN) of the processing job.
     */
    val processingJobArn: kotlin.String? = builder.processingJobArn
    /**
     * The name of the processing job. The name must be unique within an Amazon Web Services Region in the
     * Amazon Web Services account.
     */
    val processingJobName: kotlin.String? = builder.processingJobName
    /**
     * Provides the status of a processing job.
     */
    val processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = builder.processingJobStatus
    /**
     * Output configuration for the processing job.
     */
    val processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = builder.processingOutputConfig
    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
     * processing job. In distributed training, you specify more than one instance.
     */
    val processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = builder.processingResources
    /**
     * The time at which the processing job started.
     */
    val processingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.processingStartTime
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
     * your behalf.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The time limit for how long the processing job is allowed to run.
     */
    val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = builder.stoppingCondition
    /**
     * The ARN of a training job associated with this processing job.
     */
    val trainingJobArn: kotlin.String? = builder.trainingJobArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeProcessingJobResponse(")
        append("appSpecification=$appSpecification,")
        append("autoMlJobArn=$autoMlJobArn,")
        append("creationTime=$creationTime,")
        append("environment=$environment,")
        append("exitMessage=$exitMessage,")
        append("experimentConfig=$experimentConfig,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("monitoringScheduleArn=$monitoringScheduleArn,")
        append("networkConfig=$networkConfig,")
        append("processingEndTime=$processingEndTime,")
        append("processingInputs=$processingInputs,")
        append("processingJobArn=$processingJobArn,")
        append("processingJobName=$processingJobName,")
        append("processingJobStatus=$processingJobStatus,")
        append("processingOutputConfig=$processingOutputConfig,")
        append("processingResources=$processingResources,")
        append("processingStartTime=$processingStartTime,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("trainingJobArn=$trainingJobArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSpecification?.hashCode() ?: 0
        result = 31 * result + (autoMlJobArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (exitMessage?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleArn?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (processingEndTime?.hashCode() ?: 0)
        result = 31 * result + (processingInputs?.hashCode() ?: 0)
        result = 31 * result + (processingJobArn?.hashCode() ?: 0)
        result = 31 * result + (processingJobName?.hashCode() ?: 0)
        result = 31 * result + (processingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (processingOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (processingResources?.hashCode() ?: 0)
        result = 31 * result + (processingStartTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeProcessingJobResponse

        if (appSpecification != other.appSpecification) return false
        if (autoMlJobArn != other.autoMlJobArn) return false
        if (creationTime != other.creationTime) return false
        if (environment != other.environment) return false
        if (exitMessage != other.exitMessage) return false
        if (experimentConfig != other.experimentConfig) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (monitoringScheduleArn != other.monitoringScheduleArn) return false
        if (networkConfig != other.networkConfig) return false
        if (processingEndTime != other.processingEndTime) return false
        if (processingInputs != other.processingInputs) return false
        if (processingJobArn != other.processingJobArn) return false
        if (processingJobName != other.processingJobName) return false
        if (processingJobStatus != other.processingJobStatus) return false
        if (processingOutputConfig != other.processingOutputConfig) return false
        if (processingResources != other.processingResources) return false
        if (processingStartTime != other.processingStartTime) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (trainingJobArn != other.trainingJobArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configures the processing job to run a specified container image.
         */
        var appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = null
        /**
         * The ARN of an AutoML job associated with this processing job.
         */
        var autoMlJobArn: kotlin.String? = null
        /**
         * The time at which the processing job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment variables set in the Docker container.
         */
        var environment: Map<String, String>? = null
        /**
         * An optional string, up to one KB in size, that contains metadata from the processing
         * container when the processing job exits.
         */
        var exitMessage: kotlin.String? = null
        /**
         * The configuration information used to create an experiment.
         */
        var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * A string, up to one KB in size, that contains the reason a processing job failed, if
         * it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * The time at which the processing job was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of a monitoring schedule for an endpoint associated with this processing
         * job.
         */
        var monitoringScheduleArn: kotlin.String? = null
        /**
         * Networking options for a processing job.
         */
        var networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = null
        /**
         * The time at which the processing job completed.
         */
        var processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The inputs for a processing job.
         */
        var processingInputs: List<ProcessingInput>? = null
        /**
         * The Amazon Resource Name (ARN) of the processing job.
         */
        var processingJobArn: kotlin.String? = null
        /**
         * The name of the processing job. The name must be unique within an Amazon Web Services Region in the
         * Amazon Web Services account.
         */
        var processingJobName: kotlin.String? = null
        /**
         * Provides the status of a processing job.
         */
        var processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = null
        /**
         * Output configuration for the processing job.
         */
        var processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = null
        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
         * processing job. In distributed training, you specify more than one instance.
         */
        var processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = null
        /**
         * The time at which the processing job started.
         */
        var processingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         * your behalf.
         */
        var roleArn: kotlin.String? = null
        /**
         * The time limit for how long the processing job is allowed to run.
         */
        var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = null
        /**
         * The ARN of a training job associated with this processing job.
         */
        var trainingJobArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse) : this() {
            this.appSpecification = x.appSpecification
            this.autoMlJobArn = x.autoMlJobArn
            this.creationTime = x.creationTime
            this.environment = x.environment
            this.exitMessage = x.exitMessage
            this.experimentConfig = x.experimentConfig
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.monitoringScheduleArn = x.monitoringScheduleArn
            this.networkConfig = x.networkConfig
            this.processingEndTime = x.processingEndTime
            this.processingInputs = x.processingInputs
            this.processingJobArn = x.processingJobArn
            this.processingJobName = x.processingJobName
            this.processingJobStatus = x.processingJobStatus
            this.processingOutputConfig = x.processingOutputConfig
            this.processingResources = x.processingResources
            this.processingStartTime = x.processingStartTime
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.trainingJobArn = x.trainingJobArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse = DescribeProcessingJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AppSpecification] inside the given [block]
         */
        fun appSpecification(block: aws.sdk.kotlin.services.sagemaker.model.AppSpecification.Builder.() -> kotlin.Unit) {
            this.appSpecification = aws.sdk.kotlin.services.sagemaker.model.AppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NetworkConfig] inside the given [block]
         */
        fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig] inside the given [block]
         */
        fun processingOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.Builder.() -> kotlin.Unit) {
            this.processingOutputConfig = aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingResources] inside the given [block]
         */
        fun processingResources(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.Builder.() -> kotlin.Unit) {
            this.processingResources = aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.invoke(block)
        }
    }
}
