// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeMonitoringScheduleResponse private constructor(builder: Builder) {
    /**
     * The time at which the monitoring job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the endpoint for the monitoring job.
     */
    val endpointName: kotlin.String? = builder.endpointName
    /**
     * A string, up to one KB in size, that contains the reason a monitoring job failed, if it
     * failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The time at which the monitoring job was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Describes metadata on the last execution to run, if there was one.
     */
    val lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = builder.lastMonitoringExecutionSummary
    /**
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    val monitoringScheduleArn: kotlin.String? = builder.monitoringScheduleArn
    /**
     * The configuration object that specifies the monitoring schedule and defines the
     * monitoring job.
     */
    val monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = builder.monitoringScheduleConfig
    /**
     * Name of the monitoring schedule.
     */
    val monitoringScheduleName: kotlin.String? = builder.monitoringScheduleName
    /**
     * The status of an monitoring job.
     */
    val monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = builder.monitoringScheduleStatus
    /**
     * The type of the monitoring job that this schedule runs. This is one of the following
     * values.
     *
     *
     *
     * DATA_QUALITY - The schedule is for a data quality monitoring
     * job.
     *
     *
     * MODEL_QUALITY - The schedule is for a model quality monitoring
     * job.
     *
     *
     * MODEL_BIAS - The schedule is for a bias monitoring job.
     *
     *
     * MODEL_EXPLAINABILITY - The schedule is for an explainability
     * monitoring job.
     */
    val monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = builder.monitoringType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeMonitoringScheduleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMonitoringScheduleResponse(")
        append("creationTime=$creationTime,")
        append("endpointName=$endpointName,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("lastMonitoringExecutionSummary=$lastMonitoringExecutionSummary,")
        append("monitoringScheduleArn=$monitoringScheduleArn,")
        append("monitoringScheduleConfig=$monitoringScheduleConfig,")
        append("monitoringScheduleName=$monitoringScheduleName,")
        append("monitoringScheduleStatus=$monitoringScheduleStatus,")
        append("monitoringType=$monitoringType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (lastMonitoringExecutionSummary?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleArn?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleConfig?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleName?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleStatus?.hashCode() ?: 0)
        result = 31 * result + (monitoringType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeMonitoringScheduleResponse

        if (creationTime != other.creationTime) return false
        if (endpointName != other.endpointName) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (lastMonitoringExecutionSummary != other.lastMonitoringExecutionSummary) return false
        if (monitoringScheduleArn != other.monitoringScheduleArn) return false
        if (monitoringScheduleConfig != other.monitoringScheduleConfig) return false
        if (monitoringScheduleName != other.monitoringScheduleName) return false
        if (monitoringScheduleStatus != other.monitoringScheduleStatus) return false
        if (monitoringType != other.monitoringType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeMonitoringScheduleResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time at which the monitoring job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the endpoint for the monitoring job.
         */
        var endpointName: kotlin.String? = null
        /**
         * A string, up to one KB in size, that contains the reason a monitoring job failed, if it
         * failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * The time at which the monitoring job was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes metadata on the last execution to run, if there was one.
         */
        var lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = null
        /**
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         */
        var monitoringScheduleArn: kotlin.String? = null
        /**
         * The configuration object that specifies the monitoring schedule and defines the
         * monitoring job.
         */
        var monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = null
        /**
         * Name of the monitoring schedule.
         */
        var monitoringScheduleName: kotlin.String? = null
        /**
         * The status of an monitoring job.
         */
        var monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = null
        /**
         * The type of the monitoring job that this schedule runs. This is one of the following
         * values.
         *
         *
         *
         * DATA_QUALITY - The schedule is for a data quality monitoring
         * job.
         *
         *
         * MODEL_QUALITY - The schedule is for a model quality monitoring
         * job.
         *
         *
         * MODEL_BIAS - The schedule is for a bias monitoring job.
         *
         *
         * MODEL_EXPLAINABILITY - The schedule is for an explainability
         * monitoring job.
         */
        var monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeMonitoringScheduleResponse) : this() {
            this.creationTime = x.creationTime
            this.endpointName = x.endpointName
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.lastMonitoringExecutionSummary = x.lastMonitoringExecutionSummary
            this.monitoringScheduleArn = x.monitoringScheduleArn
            this.monitoringScheduleConfig = x.monitoringScheduleConfig
            this.monitoringScheduleName = x.monitoringScheduleName
            this.monitoringScheduleStatus = x.monitoringScheduleStatus
            this.monitoringType = x.monitoringType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeMonitoringScheduleResponse = DescribeMonitoringScheduleResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary] inside the given [block]
         */
        fun lastMonitoringExecutionSummary(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.Builder.() -> kotlin.Unit) {
            this.lastMonitoringExecutionSummary = aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig] inside the given [block]
         */
        fun monitoringScheduleConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.Builder.() -> kotlin.Unit) {
            this.monitoringScheduleConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.invoke(block)
        }
    }
}
