// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeEndpointResponse private constructor(builder: Builder) {
    /**
     * Returns the description of an endpoint configuration created
     * using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig
     * API.
     */
    val asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = builder.asyncInferenceConfig
    /**
     * A timestamp that shows when the endpoint was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     *
     */
    val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary? = builder.dataCaptureConfig
    /**
     * The Amazon Resource Name (ARN) of the endpoint.
     */
    val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The name of the endpoint configuration associated with this endpoint.
     */
    val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * Name of the endpoint.
     */
    val endpointName: kotlin.String? = builder.endpointName
    /**
     * The status of the endpoint.
     *
     *
     *
     * OutOfService: Endpoint is not available to take incoming
     * requests.
     *
     *
     * Creating: CreateEndpoint is executing.
     *
     *
     * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
     *
     *
     * SystemUpdating: Endpoint is undergoing maintenance and cannot be
     * updated or deleted or re-scaled until it has completed. This maintenance
     * operation does not change any customer-specified values such as VPC config, KMS
     * encryption, model, instance type, or instance count.
     *
     *
     * RollingBack: Endpoint fails to scale up or down or change its
     * variant weight and is in the process of rolling back to its previous
     * configuration. Once the rollback completes, endpoint returns to an
     * InService status. This transitional status only applies to an
     * endpoint that has autoscaling enabled and is undergoing variant weight or
     * capacity changes as part of an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities operation is called
     * explicitly.
     *
     *
     * InService: Endpoint is available to process incoming
     * requests.
     *
     *
     * Deleting: DeleteEndpoint is executing.
     *
     *
     * Failed: Endpoint could not be created, updated, or re-scaled. Use
     * DescribeEndpointOutput$FailureReason for information about
     * the failure. DeleteEndpoint is the only operation that can be
     * performed on a failed endpoint.
     */
    val endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = builder.endpointStatus
    /**
     * If the status of the endpoint is Failed, the reason why it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The most recent deployment configuration for the endpoint.
     */
    val lastDeploymentConfig: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig? = builder.lastDeploymentConfig
    /**
     * A timestamp that shows when the endpoint was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Returns the summary of an in-progress deployment. This field is only returned when the
     * endpoint is creating or updating with a new endpoint configuration.
     */
    val pendingDeploymentSummary: aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary? = builder.pendingDeploymentSummary
    /**
     * An array of ProductionVariantSummary objects, one for each model
     * hosted behind this endpoint.
     */
    val productionVariants: List<ProductionVariantSummary>? = builder.productionVariants

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEndpointResponse(")
        append("asyncInferenceConfig=$asyncInferenceConfig,")
        append("creationTime=$creationTime,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("endpointArn=$endpointArn,")
        append("endpointConfigName=$endpointConfigName,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("failureReason=$failureReason,")
        append("lastDeploymentConfig=$lastDeploymentConfig,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("pendingDeploymentSummary=$pendingDeploymentSummary,")
        append("productionVariants=$productionVariants)")
    }

    override fun hashCode(): kotlin.Int {
        var result = asyncInferenceConfig?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (pendingDeploymentSummary?.hashCode() ?: 0)
        result = 31 * result + (productionVariants?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEndpointResponse

        if (asyncInferenceConfig != other.asyncInferenceConfig) return false
        if (creationTime != other.creationTime) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (failureReason != other.failureReason) return false
        if (lastDeploymentConfig != other.lastDeploymentConfig) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (pendingDeploymentSummary != other.pendingDeploymentSummary) return false
        if (productionVariants != other.productionVariants) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Returns the description of an endpoint configuration created
         * using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
         * CreateEndpointConfig
         * API.
         */
        var asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = null
        /**
         * A timestamp that shows when the endpoint was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         *
         */
        var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint.
         */
        var endpointArn: kotlin.String? = null
        /**
         * The name of the endpoint configuration associated with this endpoint.
         */
        var endpointConfigName: kotlin.String? = null
        /**
         * Name of the endpoint.
         */
        var endpointName: kotlin.String? = null
        /**
         * The status of the endpoint.
         *
         *
         *
         * OutOfService: Endpoint is not available to take incoming
         * requests.
         *
         *
         * Creating: CreateEndpoint is executing.
         *
         *
         * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
         *
         *
         * SystemUpdating: Endpoint is undergoing maintenance and cannot be
         * updated or deleted or re-scaled until it has completed. This maintenance
         * operation does not change any customer-specified values such as VPC config, KMS
         * encryption, model, instance type, or instance count.
         *
         *
         * RollingBack: Endpoint fails to scale up or down or change its
         * variant weight and is in the process of rolling back to its previous
         * configuration. Once the rollback completes, endpoint returns to an
         * InService status. This transitional status only applies to an
         * endpoint that has autoscaling enabled and is undergoing variant weight or
         * capacity changes as part of an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities operation is called
         * explicitly.
         *
         *
         * InService: Endpoint is available to process incoming
         * requests.
         *
         *
         * Deleting: DeleteEndpoint is executing.
         *
         *
         * Failed: Endpoint could not be created, updated, or re-scaled. Use
         * DescribeEndpointOutput$FailureReason for information about
         * the failure. DeleteEndpoint is the only operation that can be
         * performed on a failed endpoint.
         */
        var endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = null
        /**
         * If the status of the endpoint is Failed, the reason why it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * The most recent deployment configuration for the endpoint.
         */
        var lastDeploymentConfig: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig? = null
        /**
         * A timestamp that shows when the endpoint was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the summary of an in-progress deployment. This field is only returned when the
         * endpoint is creating or updating with a new endpoint configuration.
         */
        var pendingDeploymentSummary: aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary? = null
        /**
         * An array of ProductionVariantSummary objects, one for each model
         * hosted behind this endpoint.
         */
        var productionVariants: List<ProductionVariantSummary>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse) : this() {
            this.asyncInferenceConfig = x.asyncInferenceConfig
            this.creationTime = x.creationTime
            this.dataCaptureConfig = x.dataCaptureConfig
            this.endpointArn = x.endpointArn
            this.endpointConfigName = x.endpointConfigName
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.failureReason = x.failureReason
            this.lastDeploymentConfig = x.lastDeploymentConfig
            this.lastModifiedTime = x.lastModifiedTime
            this.pendingDeploymentSummary = x.pendingDeploymentSummary
            this.productionVariants = x.productionVariants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse = DescribeEndpointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig] inside the given [block]
         */
        fun asyncInferenceConfig(block: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.Builder.() -> kotlin.Unit) {
            this.asyncInferenceConfig = aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary] inside the given [block]
         */
        fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig] inside the given [block]
         */
        fun lastDeploymentConfig(block: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig.Builder.() -> kotlin.Unit) {
            this.lastDeploymentConfig = aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary] inside the given [block]
         */
        fun pendingDeploymentSummary(block: aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary.Builder.() -> kotlin.Unit) {
            this.pendingDeploymentSummary = aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary.invoke(block)
        }
    }
}
