// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeEndpointConfigResponse private constructor(builder: Builder) {
    /**
     * Returns the description of an endpoint configuration created using the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig
     * API.
     */
    val asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = builder.asyncInferenceConfig
    /**
     * A timestamp that shows when the endpoint configuration was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     *
     */
    val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = builder.dataCaptureConfig
    /**
     * The Amazon Resource Name (ARN) of the endpoint configuration.
     */
    val endpointConfigArn: kotlin.String? = builder.endpointConfigArn
    /**
     * Name of the Amazon SageMaker endpoint configuration.
     */
    val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage
     * volume attached to the instance.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An array of ProductionVariant objects, one for each model that you
     * want to host at this endpoint.
     */
    val productionVariants: List<ProductionVariant>? = builder.productionVariants

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEndpointConfigResponse(")
        append("asyncInferenceConfig=$asyncInferenceConfig,")
        append("creationTime=$creationTime,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("endpointConfigArn=$endpointConfigArn,")
        append("endpointConfigName=$endpointConfigName,")
        append("kmsKeyId=$kmsKeyId,")
        append("productionVariants=$productionVariants)")
    }

    override fun hashCode(): kotlin.Int {
        var result = asyncInferenceConfig?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigArn?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (productionVariants?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEndpointConfigResponse

        if (asyncInferenceConfig != other.asyncInferenceConfig) return false
        if (creationTime != other.creationTime) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (endpointConfigArn != other.endpointConfigArn) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (productionVariants != other.productionVariants) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Returns the description of an endpoint configuration created using the
         * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
         * CreateEndpointConfig
         * API.
         */
        var asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = null
        /**
         * A timestamp that shows when the endpoint configuration was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         *
         */
        var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint configuration.
         */
        var endpointConfigArn: kotlin.String? = null
        /**
         * Name of the Amazon SageMaker endpoint configuration.
         */
        var endpointConfigName: kotlin.String? = null
        /**
         * Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage
         * volume attached to the instance.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * An array of ProductionVariant objects, one for each model that you
         * want to host at this endpoint.
         */
        var productionVariants: List<ProductionVariant>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse) : this() {
            this.asyncInferenceConfig = x.asyncInferenceConfig
            this.creationTime = x.creationTime
            this.dataCaptureConfig = x.dataCaptureConfig
            this.endpointConfigArn = x.endpointConfigArn
            this.endpointConfigName = x.endpointConfigName
            this.kmsKeyId = x.kmsKeyId
            this.productionVariants = x.productionVariants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = DescribeEndpointConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig] inside the given [block]
         */
        fun asyncInferenceConfig(block: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.Builder.() -> kotlin.Unit) {
            this.asyncInferenceConfig = aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig] inside the given [block]
         */
        fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.invoke(block)
        }
    }
}
