// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The deployment configuration for an endpoint, which contains the desired deployment
 * strategy and rollback configurations.
 */
class DeploymentConfig private constructor(builder: Builder) {
    /**
     * Automatic rollback configuration for handling endpoint deployment failures and recovery.
     */
    val autoRollbackConfiguration: aws.sdk.kotlin.services.sagemaker.model.AutoRollbackConfig? = builder.autoRollbackConfiguration
    /**
     * Update policy for a blue/green deployment. If this update policy is specified, SageMaker
     * creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
     * traffic to the new fleet according to the specified traffic routing configuration. Only
     * one update policy should be used in the deployment configuration. If no update policy is
     * specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
     * by default.
     */
    val blueGreenUpdatePolicy: aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy? = builder.blueGreenUpdatePolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfig(")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("blueGreenUpdatePolicy=$blueGreenUpdatePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoRollbackConfiguration?.hashCode() ?: 0
        result = 31 * result + (blueGreenUpdatePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentConfig

        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (blueGreenUpdatePolicy != other.blueGreenUpdatePolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Automatic rollback configuration for handling endpoint deployment failures and recovery.
         */
        var autoRollbackConfiguration: aws.sdk.kotlin.services.sagemaker.model.AutoRollbackConfig? = null
        /**
         * Update policy for a blue/green deployment. If this update policy is specified, SageMaker
         * creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
         * traffic to the new fleet according to the specified traffic routing configuration. Only
         * one update policy should be used in the deployment configuration. If no update policy is
         * specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
         * by default.
         */
        var blueGreenUpdatePolicy: aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig) : this() {
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.blueGreenUpdatePolicy = x.blueGreenUpdatePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig = DeploymentConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoRollbackConfig] inside the given [block]
         */
        fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.AutoRollbackConfig.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.sagemaker.model.AutoRollbackConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy] inside the given [block]
         */
        fun blueGreenUpdatePolicy(block: aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy.Builder.() -> kotlin.Unit) {
            this.blueGreenUpdatePolicy = aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy.invoke(block)
        }
    }
}
