// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this ProductionVariant.
 * If you used the registry/repository&#91;:tag&#93; form to specify the image path
 * of the primary container when you created the model hosted in this
 * ProductionVariant, the path resolves to a path of the form
 * registry/repository&#91;@digest&#93;. A digest is a hash value that identifies
 * a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image in the Amazon ECR User Guide.
 */
class DeployedImage private constructor(builder: Builder) {
    /**
     * The date and time when the image path for the model resolved to the
     * ResolvedImage
     */
    val resolutionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.resolutionTime
    /**
     * The specific digest path of the image hosted in this
     * ProductionVariant.
     */
    val resolvedImage: kotlin.String? = builder.resolvedImage
    /**
     * The image path you specified when you created the model.
     */
    val specifiedImage: kotlin.String? = builder.specifiedImage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DeployedImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeployedImage(")
        append("resolutionTime=$resolutionTime,")
        append("resolvedImage=$resolvedImage,")
        append("specifiedImage=$specifiedImage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resolutionTime?.hashCode() ?: 0
        result = 31 * result + (resolvedImage?.hashCode() ?: 0)
        result = 31 * result + (specifiedImage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeployedImage

        if (resolutionTime != other.resolutionTime) return false
        if (resolvedImage != other.resolvedImage) return false
        if (specifiedImage != other.specifiedImage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DeployedImage = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time when the image path for the model resolved to the
         * ResolvedImage
         */
        var resolutionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The specific digest path of the image hosted in this
         * ProductionVariant.
         */
        var resolvedImage: kotlin.String? = null
        /**
         * The image path you specified when you created the model.
         */
        var specifiedImage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DeployedImage) : this() {
            this.resolutionTime = x.resolutionTime
            this.resolvedImage = x.resolvedImage
            this.specifiedImage = x.specifiedImage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DeployedImage = DeployedImage(this)
    }
}
