// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateNotebookInstanceRequest private constructor(builder: Builder) {
    /**
     * A list of Elastic Inference (EI) instance types to associate with this notebook
     * instance. Currently, only one instance type can be associated with a notebook instance.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker.
     */
    val acceleratorTypes: List<NotebookInstanceAcceleratorType>? = builder.acceleratorTypes
    /**
     * An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account,
     * or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
     * other Git repository. These repositories are cloned at the same level as the default
     * repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
     * Repositories with Amazon SageMaker Notebook Instances.
     */
    val additionalCodeRepositories: List<String>? = builder.additionalCodeRepositories
    /**
     * A Git repository to associate with the notebook instance as its default code
     * repository. This can be either the name of a Git repository stored as a resource in your
     * account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
     * other Git repository. When you open a notebook instance, it opens in the directory that
     * contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
     * Notebook Instances.
     */
    val defaultCodeRepository: kotlin.String? = builder.defaultCodeRepository
    /**
     * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this
     * to Disabled this notebook instance is able to access resources only in your
     * VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you
     * configure a NAT Gateway in your VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default. You can set the value
     * of this parameter to Disabled only if you set a value for the
     * SubnetId parameter.
     */
    val directInternetAccess: aws.sdk.kotlin.services.sagemaker.model.DirectInternetAccess? = builder.directInternetAccess
    /**
     * The type of ML compute instance to launch for the notebook instance.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
     * the storage volume attached to your notebook instance. The KMS key you provide must be
     * enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
     * Keys in the Amazon Web Services Key Management Service Developer Guide.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of a lifecycle configuration to associate with the notebook instance. For
     * information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance.
     */
    val lifecycleConfigName: kotlin.String? = builder.lifecycleConfigName
    /**
     * The name of the new notebook instance.
     */
    val notebookInstanceName: kotlin.String? = builder.notebookInstanceName
    /**
     * The platform identifier of the notebook instance runtime environment.
     */
    val platformIdentifier: kotlin.String? = builder.platformIdentifier
    /**
     * When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
     * assumes this role to perform tasks on your behalf. You must grant this role necessary
     * permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service
     * principal (sagemaker.amazonaws.com) permissions to assume this role. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.
     *
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     * iam:PassRole permission.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Whether root access is enabled or disabled for users of the notebook instance. The
     * default value is Enabled.
     *
     * Lifecycle configurations need root access to be able to set up a notebook
     * instance. Because of this, lifecycle configurations associated with a notebook
     * instance always run with root access even if you disable root access for
     * users.
     */
    val rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = builder.rootAccess
    /**
     * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
     * for the same VPC as specified in the subnet.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnet in a VPC to which you would like to have a connectivity from
     * your ML compute instance.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     * different ways, for example, by purpose, owner, or environment. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The
     * default value is 5 GB.
     */
    val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateNotebookInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNotebookInstanceRequest(")
        append("acceleratorTypes=$acceleratorTypes,")
        append("additionalCodeRepositories=$additionalCodeRepositories,")
        append("defaultCodeRepository=$defaultCodeRepository,")
        append("directInternetAccess=$directInternetAccess,")
        append("instanceType=$instanceType,")
        append("kmsKeyId=$kmsKeyId,")
        append("lifecycleConfigName=$lifecycleConfigName,")
        append("notebookInstanceName=$notebookInstanceName,")
        append("platformIdentifier=$platformIdentifier,")
        append("roleArn=$roleArn,")
        append("rootAccess=$rootAccess,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("volumeSizeInGb=$volumeSizeInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorTypes?.hashCode() ?: 0
        result = 31 * result + (additionalCodeRepositories?.hashCode() ?: 0)
        result = 31 * result + (defaultCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (directInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfigName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceName?.hashCode() ?: 0)
        result = 31 * result + (platformIdentifier?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rootAccess?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNotebookInstanceRequest

        if (acceleratorTypes != other.acceleratorTypes) return false
        if (additionalCodeRepositories != other.additionalCodeRepositories) return false
        if (defaultCodeRepository != other.defaultCodeRepository) return false
        if (directInternetAccess != other.directInternetAccess) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lifecycleConfigName != other.lifecycleConfigName) return false
        if (notebookInstanceName != other.notebookInstanceName) return false
        if (platformIdentifier != other.platformIdentifier) return false
        if (roleArn != other.roleArn) return false
        if (rootAccess != other.rootAccess) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateNotebookInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of Elastic Inference (EI) instance types to associate with this notebook
         * instance. Currently, only one instance type can be associated with a notebook instance.
         * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker.
         */
        var acceleratorTypes: List<NotebookInstanceAcceleratorType>? = null
        /**
         * An array of up to three Git repositories to associate with the notebook instance.
         * These can be either the names of Git repositories stored as resources in your account,
         * or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
         * other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
         * Repositories with Amazon SageMaker Notebook Instances.
         */
        var additionalCodeRepositories: List<String>? = null
        /**
         * A Git repository to associate with the notebook instance as its default code
         * repository. This can be either the name of a Git repository stored as a resource in your
         * account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit or in any
         * other Git repository. When you open a notebook instance, it opens in the directory that
         * contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
         * Notebook Instances.
         */
        var defaultCodeRepository: kotlin.String? = null
        /**
         * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this
         * to Disabled this notebook instance is able to access resources only in your
         * VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you
         * configure a NAT Gateway in your VPC.
         * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default. You can set the value
         * of this parameter to Disabled only if you set a value for the
         * SubnetId parameter.
         */
        var directInternetAccess: aws.sdk.kotlin.services.sagemaker.model.DirectInternetAccess? = null
        /**
         * The type of ML compute instance to launch for the notebook instance.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = null
        /**
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
         * the storage volume attached to your notebook instance. The KMS key you provide must be
         * enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
         * Keys in the Amazon Web Services Key Management Service Developer Guide.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of a lifecycle configuration to associate with the notebook instance. For
         * information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance.
         */
        var lifecycleConfigName: kotlin.String? = null
        /**
         * The name of the new notebook instance.
         */
        var notebookInstanceName: kotlin.String? = null
        /**
         * The platform identifier of the notebook instance runtime environment.
         */
        var platformIdentifier: kotlin.String? = null
        /**
         * When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
         * assumes this role to perform tasks on your behalf. You must grant this role necessary
         * permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service
         * principal (sagemaker.amazonaws.com) permissions to assume this role. For more
         * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.
         *
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * iam:PassRole permission.
         */
        var roleArn: kotlin.String? = null
        /**
         * Whether root access is enabled or disabled for users of the notebook instance. The
         * default value is Enabled.
         *
         * Lifecycle configurations need root access to be able to set up a notebook
         * instance. Because of this, lifecycle configurations associated with a notebook
         * instance always run with root access even if you disable root access for
         * users.
         */
        var rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = null
        /**
         * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
         * for the same VPC as specified in the subnet.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnet in a VPC to which you would like to have a connectivity from
         * your ML compute instance.
         */
        var subnetId: kotlin.String? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         * different ways, for example, by purpose, owner, or environment. For more information,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources.
         */
        var tags: List<Tag>? = null
        /**
         * The size, in GB, of the ML storage volume to attach to the notebook instance. The
         * default value is 5 GB.
         */
        var volumeSizeInGb: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateNotebookInstanceRequest) : this() {
            this.acceleratorTypes = x.acceleratorTypes
            this.additionalCodeRepositories = x.additionalCodeRepositories
            this.defaultCodeRepository = x.defaultCodeRepository
            this.directInternetAccess = x.directInternetAccess
            this.instanceType = x.instanceType
            this.kmsKeyId = x.kmsKeyId
            this.lifecycleConfigName = x.lifecycleConfigName
            this.notebookInstanceName = x.notebookInstanceName
            this.platformIdentifier = x.platformIdentifier
            this.roleArn = x.roleArn
            this.rootAccess = x.rootAccess
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateNotebookInstanceRequest = CreateNotebookInstanceRequest(this)
    }
}
