// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateModelRequest private constructor(builder: Builder) {
    /**
     * Specifies the containers in the inference pipeline.
     */
    val containers: List<ContainerDefinition>? = builder.containers
    /**
     * Isolates the model container. No inbound or outbound network calls can be made to or
     * from the model container.
     */
    val enableNetworkIsolation: kotlin.Boolean = builder.enableNetworkIsolation
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model
     * artifacts and docker image for deployment on ML compute instances or for batch transform
     * jobs. Deploying on ML compute instances is part of model hosting. For more information,
     * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
     * Roles.
     *
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     * iam:PassRole permission.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Specifies details of how containers in a multi-container endpoint are called.
     */
    val inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = builder.inferenceExecutionConfig
    /**
     * The name of the new model.
     */
    val modelName: kotlin.String? = builder.modelName
    /**
     * The location of the primary docker image containing inference code, associated
     * artifacts, and custom environment map that the inference code uses when the model is
     * deployed for predictions.
     */
    val primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = builder.primaryContainer
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     * different ways, for example, by purpose, owner, or environment. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A VpcConfig object that specifies the VPC that you want your model
     * to connect to. Control access to and from your model container by configuring the VPC.
     * VpcConfig is used in hosting services and in batch transform. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch
     * Transform Jobs by Using an Amazon Virtual Private Cloud.
     */
    val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelRequest(")
        append("containers=$containers,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("executionRoleArn=$executionRoleArn,")
        append("inferenceExecutionConfig=$inferenceExecutionConfig,")
        append("modelName=$modelName,")
        append("primaryContainer=$primaryContainer,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (enableNetworkIsolation.hashCode())
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inferenceExecutionConfig?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (primaryContainer?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelRequest

        if (containers != other.containers) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inferenceExecutionConfig != other.inferenceExecutionConfig) return false
        if (modelName != other.modelName) return false
        if (primaryContainer != other.primaryContainer) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the containers in the inference pipeline.
         */
        var containers: List<ContainerDefinition>? = null
        /**
         * Isolates the model container. No inbound or outbound network calls can be made to or
         * from the model container.
         */
        var enableNetworkIsolation: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model
         * artifacts and docker image for deployment on ML compute instances or for batch transform
         * jobs. Deploying on ML compute instances is part of model hosting. For more information,
         * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
         * Roles.
         *
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * iam:PassRole permission.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * Specifies details of how containers in a multi-container endpoint are called.
         */
        var inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = null
        /**
         * The name of the new model.
         */
        var modelName: kotlin.String? = null
        /**
         * The location of the primary docker image containing inference code, associated
         * artifacts, and custom environment map that the inference code uses when the model is
         * deployed for predictions.
         */
        var primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         * different ways, for example, by purpose, owner, or environment. For more information,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources.
         */
        var tags: List<Tag>? = null
        /**
         * A VpcConfig object that specifies the VPC that you want your model
         * to connect to. Control access to and from your model container by configuring the VPC.
         * VpcConfig is used in hosting services and in batch transform. For more
         * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch
         * Transform Jobs by Using an Amazon Virtual Private Cloud.
         */
        var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest) : this() {
            this.containers = x.containers
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.executionRoleArn = x.executionRoleArn
            this.inferenceExecutionConfig = x.inferenceExecutionConfig
            this.modelName = x.modelName
            this.primaryContainer = x.primaryContainer
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = CreateModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig] inside the given [block]
         */
        fun inferenceExecutionConfig(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.Builder.() -> kotlin.Unit) {
            this.inferenceExecutionConfig = aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition] inside the given [block]
         */
        fun primaryContainer(block: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.Builder.() -> kotlin.Unit) {
            this.primaryContainer = aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }
    }
}
