// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateLabelingJobRequest private constructor(builder: Builder) {
    /**
     * Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).
     */
    val humanTaskConfig: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig? = builder.humanTaskConfig
    /**
     * Input data for the labeling job, such as the Amazon S3 location of the data objects and the
     * location of the manifest file that describes the data objects.
     * You must specify at least one of the following: S3DataSource or
     * SnsDataSource.
     *
     *
     * Use SnsDataSource to specify an SNS input topic for a streaming
     * labeling job. If you do not specify and SNS input topic ARN, Ground Truth will
     * create a one-time labeling job that stops after all data objects in the input
     * manifest file have been labeled.
     *
     * Use S3DataSource to specify an input manifest file for both
     * streaming and one-time labeling jobs. Adding an S3DataSource is
     * optional if you use SnsDataSource to create a streaming labeling
     * job.
     *
     *
     * If you use the Amazon Mechanical Turk workforce, your input data should not include
     * confidential information, personal information or protected health information. Use
     * ContentClassifiers to specify that your data is free of personally
     * identifiable information and adult content.
     */
    val inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = builder.inputConfig
    /**
     * The attribute name to use for the label in the output manifest file. This is the key
     * for the key/value pair formed with the label that a worker assigns to the object. The
     * LabelAttributeName must meet the following requirements.
     *
     *
     * The name can't end with "-metadata".
     *
     * If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types,
     * the attribute name must end with "-ref". If the task type
     * you are using is not listed below, the attribute name must
     * not end with "-ref".
     *
     *
     * Image semantic segmentation (SemanticSegmentation), and
     * adjustment (AdjustmentSemanticSegmentation) and
     * verification (VerificationSemanticSegmentation) labeling
     * jobs for this task type.
     *
     *
     * Video frame object detection (VideoObjectDetection), and
     * adjustment and verification
     * (AdjustmentVideoObjectDetection) labeling jobs for this
     * task type.
     *
     *
     * Video frame object tracking (VideoObjectTracking), and
     * adjustment and verification (AdjustmentVideoObjectTracking)
     * labeling jobs for this task type.
     *
     *
     * 3D point cloud semantic segmentation
     * (3DPointCloudSemanticSegmentation), and adjustment and
     * verification (Adjustment3DPointCloudSemanticSegmentation)
     * labeling jobs for this task type.
     *
     *
     * 3D point cloud object tracking
     * (3DPointCloudObjectTracking), and adjustment and
     * verification (Adjustment3DPointCloudObjectTracking)
     * labeling jobs for this task type.
     *
     *
     *
     *
     *
     * If you are creating an adjustment or verification labeling job, you must use a
     * different
     * LabelAttributeName than the one used in the original labeling job. The
     * original labeling job is the Ground Truth labeling job that produced the labels that you
     * want verified or adjusted. To learn more about adjustment and verification labeling
     * jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
     * Labels.
     */
    val labelAttributeName: kotlin.String? = builder.labelAttributeName
    /**
     * The S3 URI of the file, referred to as a label category configuration
     * file, that defines the categories used to label the data objects.
     * For 3D point cloud and video frame task types, you can add label category attributes
     * and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
     * Labeling Category Configuration File for 3D Point Cloud Labeling Jobs.
     * For named entity recognition jobs, in addition to "labels", you must
     * provide worker instructions in the label category configuration file using the
     * "instructions" parameter: "instructions":
     * {"shortInstruction":"<h1>Add header</h1>Add Instructions",
     * "fullInstruction":"Add additional instructions."}. For details
     * and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a
     * Named Entity Recognition Labeling Job (API) .
     * For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
     * tasks, your label category configuration file must be a JSON file in the
     * following format. Identify the labels you want to use by replacing label_1,
     * label_2,...,label_n with your label
     * categories.
     *
     * {
     *
     *
     * "document-version": "2018-11-28",
     *
     *
     * "labels": &#91;{"label": "label_1"},{"label": "label_2"},...{"label":
     * "label_n"}&#93;
     *
     *
     * }
     *
     * Note the following about the label category configuration file:
     *
     *
     * For image classification and text classification (single and multi-label) you
     * must specify at least two label categories. For all other task types, the
     * minimum number of label categories required is one.
     *
     * Each label category must be unique, you cannot specify duplicate label
     * categories.
     *
     * If you create a 3D point cloud or video frame adjustment or verification
     * labeling job, you must include auditLabelAttributeName in the label
     * category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName">
     * LabelAttributeName
     * of the labeling job you want to
     * adjust or verify annotations of.
     */
    val labelCategoryConfigS3Uri: kotlin.String? = builder.labelCategoryConfigS3Uri
    /**
     * Configures the information required to perform automated data labeling.
     */
    val labelingJobAlgorithmsConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig? = builder.labelingJobAlgorithmsConfig
    /**
     * The name of the labeling job. This name is used to identify the job in a list of
     * labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region.
     * LabelingJobName is not case sensitive. For example, Example-job and
     * example-job are considered the same labeling job name by Ground Truth.
     */
    val labelingJobName: kotlin.String? = builder.labelingJobName
    /**
     * The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt
     * the output data, if any.
     */
    val outputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf
     * during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker
     * can successfully complete data labeling.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A set of conditions for stopping the labeling job. If any of the conditions are met,
     * the job is automatically stopped. You can use these conditions to control the cost of
     * data labeling.
     */
    val stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions? = builder.stoppingConditions
    /**
     * An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management
     * User Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateLabelingJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLabelingJobRequest(")
        append("humanTaskConfig=$humanTaskConfig,")
        append("inputConfig=$inputConfig,")
        append("labelAttributeName=$labelAttributeName,")
        append("labelCategoryConfigS3Uri=$labelCategoryConfigS3Uri,")
        append("labelingJobAlgorithmsConfig=$labelingJobAlgorithmsConfig,")
        append("labelingJobName=$labelingJobName,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("stoppingConditions=$stoppingConditions,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = humanTaskConfig?.hashCode() ?: 0
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (labelAttributeName?.hashCode() ?: 0)
        result = 31 * result + (labelCategoryConfigS3Uri?.hashCode() ?: 0)
        result = 31 * result + (labelingJobAlgorithmsConfig?.hashCode() ?: 0)
        result = 31 * result + (labelingJobName?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingConditions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLabelingJobRequest

        if (humanTaskConfig != other.humanTaskConfig) return false
        if (inputConfig != other.inputConfig) return false
        if (labelAttributeName != other.labelAttributeName) return false
        if (labelCategoryConfigS3Uri != other.labelCategoryConfigS3Uri) return false
        if (labelingJobAlgorithmsConfig != other.labelingJobAlgorithmsConfig) return false
        if (labelingJobName != other.labelingJobName) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingConditions != other.stoppingConditions) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateLabelingJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).
         */
        var humanTaskConfig: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig? = null
        /**
         * Input data for the labeling job, such as the Amazon S3 location of the data objects and the
         * location of the manifest file that describes the data objects.
         * You must specify at least one of the following: S3DataSource or
         * SnsDataSource.
         *
         *
         * Use SnsDataSource to specify an SNS input topic for a streaming
         * labeling job. If you do not specify and SNS input topic ARN, Ground Truth will
         * create a one-time labeling job that stops after all data objects in the input
         * manifest file have been labeled.
         *
         * Use S3DataSource to specify an input manifest file for both
         * streaming and one-time labeling jobs. Adding an S3DataSource is
         * optional if you use SnsDataSource to create a streaming labeling
         * job.
         *
         *
         * If you use the Amazon Mechanical Turk workforce, your input data should not include
         * confidential information, personal information or protected health information. Use
         * ContentClassifiers to specify that your data is free of personally
         * identifiable information and adult content.
         */
        var inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = null
        /**
         * The attribute name to use for the label in the output manifest file. This is the key
         * for the key/value pair formed with the label that a worker assigns to the object. The
         * LabelAttributeName must meet the following requirements.
         *
         *
         * The name can't end with "-metadata".
         *
         * If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types,
         * the attribute name must end with "-ref". If the task type
         * you are using is not listed below, the attribute name must
         * not end with "-ref".
         *
         *
         * Image semantic segmentation (SemanticSegmentation), and
         * adjustment (AdjustmentSemanticSegmentation) and
         * verification (VerificationSemanticSegmentation) labeling
         * jobs for this task type.
         *
         *
         * Video frame object detection (VideoObjectDetection), and
         * adjustment and verification
         * (AdjustmentVideoObjectDetection) labeling jobs for this
         * task type.
         *
         *
         * Video frame object tracking (VideoObjectTracking), and
         * adjustment and verification (AdjustmentVideoObjectTracking)
         * labeling jobs for this task type.
         *
         *
         * 3D point cloud semantic segmentation
         * (3DPointCloudSemanticSegmentation), and adjustment and
         * verification (Adjustment3DPointCloudSemanticSegmentation)
         * labeling jobs for this task type.
         *
         *
         * 3D point cloud object tracking
         * (3DPointCloudObjectTracking), and adjustment and
         * verification (Adjustment3DPointCloudObjectTracking)
         * labeling jobs for this task type.
         *
         *
         *
         *
         *
         * If you are creating an adjustment or verification labeling job, you must use a
         * different
         * LabelAttributeName than the one used in the original labeling job. The
         * original labeling job is the Ground Truth labeling job that produced the labels that you
         * want verified or adjusted. To learn more about adjustment and verification labeling
         * jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
         * Labels.
         */
        var labelAttributeName: kotlin.String? = null
        /**
         * The S3 URI of the file, referred to as a label category configuration
         * file, that defines the categories used to label the data objects.
         * For 3D point cloud and video frame task types, you can add label category attributes
         * and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
         * Labeling Category Configuration File for 3D Point Cloud Labeling Jobs.
         * For named entity recognition jobs, in addition to "labels", you must
         * provide worker instructions in the label category configuration file using the
         * "instructions" parameter: "instructions":
         * {"shortInstruction":"<h1>Add header</h1>Add Instructions",
         * "fullInstruction":"Add additional instructions."}. For details
         * and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a
         * Named Entity Recognition Labeling Job (API) .
         * For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
         * tasks, your label category configuration file must be a JSON file in the
         * following format. Identify the labels you want to use by replacing label_1,
         * label_2,...,label_n with your label
         * categories.
         *
         * {
         *
         *
         * "document-version": "2018-11-28",
         *
         *
         * "labels": &#91;{"label": "label_1"},{"label": "label_2"},...{"label":
         * "label_n"}&#93;
         *
         *
         * }
         *
         * Note the following about the label category configuration file:
         *
         *
         * For image classification and text classification (single and multi-label) you
         * must specify at least two label categories. For all other task types, the
         * minimum number of label categories required is one.
         *
         * Each label category must be unique, you cannot specify duplicate label
         * categories.
         *
         * If you create a 3D point cloud or video frame adjustment or verification
         * labeling job, you must include auditLabelAttributeName in the label
         * category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName">
         * LabelAttributeName
         * of the labeling job you want to
         * adjust or verify annotations of.
         */
        var labelCategoryConfigS3Uri: kotlin.String? = null
        /**
         * Configures the information required to perform automated data labeling.
         */
        var labelingJobAlgorithmsConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig? = null
        /**
         * The name of the labeling job. This name is used to identify the job in a list of
         * labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region.
         * LabelingJobName is not case sensitive. For example, Example-job and
         * example-job are considered the same labeling job name by Ground Truth.
         */
        var labelingJobName: kotlin.String? = null
        /**
         * The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt
         * the output data, if any.
         */
        var outputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig? = null
        /**
         * The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf
         * during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker
         * can successfully complete data labeling.
         */
        var roleArn: kotlin.String? = null
        /**
         * A set of conditions for stopping the labeling job. If any of the conditions are met,
         * the job is automatically stopped. You can use these conditions to control the cost of
         * data labeling.
         */
        var stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions? = null
        /**
         * An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management
         * User Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateLabelingJobRequest) : this() {
            this.humanTaskConfig = x.humanTaskConfig
            this.inputConfig = x.inputConfig
            this.labelAttributeName = x.labelAttributeName
            this.labelCategoryConfigS3Uri = x.labelCategoryConfigS3Uri
            this.labelingJobAlgorithmsConfig = x.labelingJobAlgorithmsConfig
            this.labelingJobName = x.labelingJobName
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.stoppingConditions = x.stoppingConditions
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateLabelingJobRequest = CreateLabelingJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig] inside the given [block]
         */
        fun humanTaskConfig(block: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig.Builder.() -> kotlin.Unit) {
            this.humanTaskConfig = aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig] inside the given [block]
         */
        fun inputConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig] inside the given [block]
         */
        fun labelingJobAlgorithmsConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig.Builder.() -> kotlin.Unit) {
            this.labelingJobAlgorithmsConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig] inside the given [block]
         */
        fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions] inside the given [block]
         */
        fun stoppingConditions(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions.Builder.() -> kotlin.Unit) {
            this.stoppingConditions = aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions.invoke(block)
        }
    }
}
