// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Use this parameter to configure your Amazon Cognito workforce.
 * A single Cognito workforce is created using and corresponds to a single
 * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
 * Amazon Cognito user pool.
 */
class CognitoConfig private constructor(builder: Builder) {
    /**
     * The client ID for your Amazon Cognito user pool.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
     * user pool is a user directory in Amazon Cognito.
     * With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
     * Your users can also sign in through social identity providers like
     * Google, Facebook, Amazon, or Apple, and through SAML identity providers.
     */
    val userPool: kotlin.String? = builder.userPool

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CognitoConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoConfig(")
        append("clientId=$clientId,")
        append("userPool=$userPool)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (userPool?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoConfig

        if (clientId != other.clientId) return false
        if (userPool != other.userPool) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CognitoConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The client ID for your Amazon Cognito user pool.
         */
        var clientId: kotlin.String? = null
        /**
         * A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
         * user pool is a user directory in Amazon Cognito.
         * With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
         * Your users can also sign in through social identity providers like
         * Google, Facebook, Amazon, or Apple, and through SAML identity providers.
         */
        var userPool: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig) : this() {
            this.clientId = x.clientId
            this.userPool = x.userPool
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CognitoConfig = CognitoConfig(this)
    }
}
