// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A channel is a named input source that training algorithms can consume.
 */
class Channel private constructor(builder: Builder) {
    /**
     * The name of the channel.
     */
    val channelName: kotlin.String? = builder.channelName
    /**
     * If training data is compressed, the compression type. The default value is
     * None. CompressionType is used only in Pipe input mode. In
     * File mode, leave this field unset or set it to None.
     */
    val compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = builder.compressionType
    /**
     * The MIME type of the data.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * The location of the channel data.
     */
    val dataSource: aws.sdk.kotlin.services.sagemaker.model.DataSource? = builder.dataSource
    /**
     * (Optional) The input mode to use for the data channel in a training job. If you don't
     * set a value for InputMode, Amazon SageMaker uses the value set for
     * TrainingInputMode. Use this parameter to override the
     * TrainingInputMode setting in a AlgorithmSpecification
     * request when you have a channel that needs a different input mode from the training
     * job's general setting. To download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML
     * storage volume, and mount the directory to a Docker volume, use File input
     * mode. To stream data directly from Amazon S3 to the container, choose Pipe input
     * mode.
     * To use a model for incremental training, choose File input model.
     */
    val inputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = builder.inputMode
    /**
     * Specify RecordIO as the value when input data is in raw format but the training
     * algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps each individual S3
     * object in a RecordIO record. If the input data is already in RecordIO format, you don't
     * need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create
     * a Dataset Using RecordIO.
     * In File mode, leave this field unset or set it to None.
     */
    val recordWrapperType: aws.sdk.kotlin.services.sagemaker.model.RecordWrapper? = builder.recordWrapperType
    /**
     * A configuration for a shuffle option for input data in a channel. If you use
     * S3Prefix for S3DataType, this shuffles the results of the
     * S3 key prefix matches. If you use ManifestFile, the order of the S3 object
     * references in the ManifestFile is shuffled. If you use
     * AugmentedManifestFile, the order of the JSON lines in the
     * AugmentedManifestFile is shuffled. The shuffling order is determined
     * using the Seed value.
     * For Pipe input mode, shuffling is done at the start of every epoch. With large
     * datasets this ensures that the order of the training data is different for each epoch,
     * it helps reduce bias and possible overfitting. In a multi-node training job when
     * ShuffleConfig is combined with S3DataDistributionType of
     * ShardedByS3Key, the data is shuffled across nodes so that the content
     * sent to a particular node on the first epoch might be sent to a different node on the
     * second epoch.
     */
    val shuffleConfig: aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig? = builder.shuffleConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Channel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("channelName=$channelName,")
        append("compressionType=$compressionType,")
        append("contentType=$contentType,")
        append("dataSource=$dataSource,")
        append("inputMode=$inputMode,")
        append("recordWrapperType=$recordWrapperType,")
        append("shuffleConfig=$shuffleConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (compressionType?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (inputMode?.hashCode() ?: 0)
        result = 31 * result + (recordWrapperType?.hashCode() ?: 0)
        result = 31 * result + (shuffleConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Channel

        if (channelName != other.channelName) return false
        if (compressionType != other.compressionType) return false
        if (contentType != other.contentType) return false
        if (dataSource != other.dataSource) return false
        if (inputMode != other.inputMode) return false
        if (recordWrapperType != other.recordWrapperType) return false
        if (shuffleConfig != other.shuffleConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Channel = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the channel.
         */
        var channelName: kotlin.String? = null
        /**
         * If training data is compressed, the compression type. The default value is
         * None. CompressionType is used only in Pipe input mode. In
         * File mode, leave this field unset or set it to None.
         */
        var compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = null
        /**
         * The MIME type of the data.
         */
        var contentType: kotlin.String? = null
        /**
         * The location of the channel data.
         */
        var dataSource: aws.sdk.kotlin.services.sagemaker.model.DataSource? = null
        /**
         * (Optional) The input mode to use for the data channel in a training job. If you don't
         * set a value for InputMode, Amazon SageMaker uses the value set for
         * TrainingInputMode. Use this parameter to override the
         * TrainingInputMode setting in a AlgorithmSpecification
         * request when you have a channel that needs a different input mode from the training
         * job's general setting. To download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML
         * storage volume, and mount the directory to a Docker volume, use File input
         * mode. To stream data directly from Amazon S3 to the container, choose Pipe input
         * mode.
         * To use a model for incremental training, choose File input model.
         */
        var inputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = null
        /**
         * Specify RecordIO as the value when input data is in raw format but the training
         * algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps each individual S3
         * object in a RecordIO record. If the input data is already in RecordIO format, you don't
         * need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create
         * a Dataset Using RecordIO.
         * In File mode, leave this field unset or set it to None.
         */
        var recordWrapperType: aws.sdk.kotlin.services.sagemaker.model.RecordWrapper? = null
        /**
         * A configuration for a shuffle option for input data in a channel. If you use
         * S3Prefix for S3DataType, this shuffles the results of the
         * S3 key prefix matches. If you use ManifestFile, the order of the S3 object
         * references in the ManifestFile is shuffled. If you use
         * AugmentedManifestFile, the order of the JSON lines in the
         * AugmentedManifestFile is shuffled. The shuffling order is determined
         * using the Seed value.
         * For Pipe input mode, shuffling is done at the start of every epoch. With large
         * datasets this ensures that the order of the training data is different for each epoch,
         * it helps reduce bias and possible overfitting. In a multi-node training job when
         * ShuffleConfig is combined with S3DataDistributionType of
         * ShardedByS3Key, the data is shuffled across nodes so that the content
         * sent to a particular node on the first epoch might be sent to a different node on the
         * second epoch.
         */
        var shuffleConfig: aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Channel) : this() {
            this.channelName = x.channelName
            this.compressionType = x.compressionType
            this.contentType = x.contentType
            this.dataSource = x.dataSource
            this.inputMode = x.inputMode
            this.recordWrapperType = x.recordWrapperType
            this.shuffleConfig = x.shuffleConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Channel = Channel(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataSource] inside the given [block]
         */
        fun dataSource(block: aws.sdk.kotlin.services.sagemaker.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.sagemaker.model.DataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig] inside the given [block]
         */
        fun shuffleConfig(block: aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig.Builder.() -> kotlin.Unit) {
            this.shuffleConfig = aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig.invoke(block)
        }
    }
}
