// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration for Athena Dataset Definition input.
 */
class AthenaDatasetDefinition private constructor(builder: Builder) {
    /**
     * The name of the data catalog used in Athena query execution.
     */
    val catalog: kotlin.String? = builder.catalog
    /**
     * The name of the database used in the Athena query execution.
     */
    val database: kotlin.String? = builder.database
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data generated from
     * an Athena query execution.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The compression used for Athena query results.
     */
    val outputCompression: aws.sdk.kotlin.services.sagemaker.model.AthenaResultCompressionType? = builder.outputCompression
    /**
     * The data storage format for Athena query results.
     */
    val outputFormat: aws.sdk.kotlin.services.sagemaker.model.AthenaResultFormat? = builder.outputFormat
    /**
     * The location in Amazon S3 where Athena query results are stored.
     */
    val outputS3Uri: kotlin.String? = builder.outputS3Uri
    /**
     * The SQL query statements, to be executed.
     */
    val queryString: kotlin.String? = builder.queryString
    /**
     * The name of the workgroup in which the Athena query is being started.
     */
    val workGroup: kotlin.String? = builder.workGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AthenaDatasetDefinition(")
        append("catalog=$catalog,")
        append("database=$database,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputCompression=$outputCompression,")
        append("outputFormat=$outputFormat,")
        append("outputS3Uri=$outputS3Uri,")
        append("queryString=$queryString,")
        append("workGroup=$workGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalog?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputCompression?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (outputS3Uri?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AthenaDatasetDefinition

        if (catalog != other.catalog) return false
        if (database != other.database) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputCompression != other.outputCompression) return false
        if (outputFormat != other.outputFormat) return false
        if (outputS3Uri != other.outputS3Uri) return false
        if (queryString != other.queryString) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the data catalog used in Athena query execution.
         */
        var catalog: kotlin.String? = null
        /**
         * The name of the database used in the Athena query execution.
         */
        var database: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data generated from
         * an Athena query execution.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The compression used for Athena query results.
         */
        var outputCompression: aws.sdk.kotlin.services.sagemaker.model.AthenaResultCompressionType? = null
        /**
         * The data storage format for Athena query results.
         */
        var outputFormat: aws.sdk.kotlin.services.sagemaker.model.AthenaResultFormat? = null
        /**
         * The location in Amazon S3 where Athena query results are stored.
         */
        var outputS3Uri: kotlin.String? = null
        /**
         * The SQL query statements, to be executed.
         */
        var queryString: kotlin.String? = null
        /**
         * The name of the workgroup in which the Athena query is being started.
         */
        var workGroup: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition) : this() {
            this.catalog = x.catalog
            this.database = x.database
            this.kmsKeyId = x.kmsKeyId
            this.outputCompression = x.outputCompression
            this.outputFormat = x.outputFormat
            this.outputS3Uri = x.outputS3Uri
            this.queryString = x.queryString
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition = AthenaDatasetDefinition(this)
    }
}
