// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists a summary of the properties of an association. An association is an entity that
 * links other lineage or experiment entities. An example would be an association between a
 * training job and a model.
 */
class AssociationSummary private constructor(builder: Builder) {
    /**
     * The type of the association.
     */
    val associationType: aws.sdk.kotlin.services.sagemaker.model.AssociationEdgeType? = builder.associationType
    /**
     * Information about the user who created or modified an experiment, trial, trial
     * component, lineage group, or project.
     */
    val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * When the association was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the destination.
     */
    val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The name of the destination.
     */
    val destinationName: kotlin.String? = builder.destinationName
    /**
     * The destination type.
     */
    val destinationType: kotlin.String? = builder.destinationType
    /**
     * The ARN of the source.
     */
    val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The name of the source.
     */
    val sourceName: kotlin.String? = builder.sourceName
    /**
     * The source type.
     */
    val sourceType: kotlin.String? = builder.sourceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociationSummary(")
        append("associationType=$associationType,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("destinationArn=$destinationArn,")
        append("destinationName=$destinationName,")
        append("destinationType=$destinationType,")
        append("sourceArn=$sourceArn,")
        append("sourceName=$sourceName,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationType?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (destinationType?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociationSummary

        if (associationType != other.associationType) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (destinationArn != other.destinationArn) return false
        if (destinationName != other.destinationName) return false
        if (destinationType != other.destinationType) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceName != other.sourceName) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AssociationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of the association.
         */
        var associationType: aws.sdk.kotlin.services.sagemaker.model.AssociationEdgeType? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial
         * component, lineage group, or project.
         */
        var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the association was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the destination.
         */
        var destinationArn: kotlin.String? = null
        /**
         * The name of the destination.
         */
        var destinationName: kotlin.String? = null
        /**
         * The destination type.
         */
        var destinationType: kotlin.String? = null
        /**
         * The ARN of the source.
         */
        var sourceArn: kotlin.String? = null
        /**
         * The name of the source.
         */
        var sourceName: kotlin.String? = null
        /**
         * The source type.
         */
        var sourceType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AssociationSummary) : this() {
            this.associationType = x.associationType
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.destinationArn = x.destinationArn
            this.destinationName = x.destinationName
            this.destinationType = x.destinationType
            this.sourceArn = x.sourceArn
            this.sourceName = x.sourceName
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AssociationSummary = AssociationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }
    }
}
