// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.waiters

import aws.sdk.kotlin.services.sagemaker.SageMakerClient
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun SageMakerClient.waitUntilEndpointDeleted(request: DescribeEndpointRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeEndpointResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeEndpointRequest, DescribeEndpointResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpointStatus = it.endpointStatus?.value
            endpointStatus == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEndpoint(request) }
}

public suspend fun SageMakerClient.waitUntilEndpointDeleted(block: DescribeEndpointRequest.Builder.() -> Unit): Outcome<DescribeEndpointResponse> =
    waitUntilEndpointDeleted(DescribeEndpointRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilEndpointInService(request: DescribeEndpointRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeEndpointResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeEndpointRequest, DescribeEndpointResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val endpointStatus = it.endpointStatus?.value
            endpointStatus == "InService"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpointStatus = it.endpointStatus?.value
            endpointStatus == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEndpoint(request) }
}

public suspend fun SageMakerClient.waitUntilEndpointInService(block: DescribeEndpointRequest.Builder.() -> Unit): Outcome<DescribeEndpointResponse> =
    waitUntilEndpointInService(DescribeEndpointRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageCreated(request: DescribeImageRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeImageResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageStatus = it.imageStatus?.value
            imageStatus == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it.imageStatus?.value
            imageStatus == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageCreated(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageCreated(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageDeleted(request: DescribeImageRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeImageResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it.imageStatus?.value
            imageStatus == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageDeleted(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageDeleted(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageUpdated(request: DescribeImageRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeImageResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageStatus = it.imageStatus?.value
            imageStatus == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it.imageStatus?.value
            imageStatus == "UPDATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageUpdated(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageUpdated(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageVersionCreated(request: DescribeImageVersionRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeImageVersionResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageVersionRequest, DescribeImageVersionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageVersionStatus = it.imageVersionStatus?.value
            imageVersionStatus == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageVersionStatus = it.imageVersionStatus?.value
            imageVersionStatus == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImageVersion(request) }
}

public suspend fun SageMakerClient.waitUntilImageVersionCreated(block: DescribeImageVersionRequest.Builder.() -> Unit): Outcome<DescribeImageVersionResponse> =
    waitUntilImageVersionCreated(DescribeImageVersionRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageVersionDeleted(request: DescribeImageVersionRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeImageVersionResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageVersionRequest, DescribeImageVersionResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageVersionStatus = it.imageVersionStatus?.value
            imageVersionStatus == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImageVersion(request) }
}

public suspend fun SageMakerClient.waitUntilImageVersionDeleted(block: DescribeImageVersionRequest.Builder.() -> Unit): Outcome<DescribeImageVersionResponse> =
    waitUntilImageVersionDeleted(DescribeImageVersionRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceDeleted(request: DescribeNotebookInstanceRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it.notebookInstanceStatus?.value
            notebookInstanceStatus == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceDeleted(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceInService(request: DescribeNotebookInstanceRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val notebookInstanceStatus = it.notebookInstanceStatus?.value
            notebookInstanceStatus == "InService"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it.notebookInstanceStatus?.value
            notebookInstanceStatus == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceInService(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceStopped(request: DescribeNotebookInstanceRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val notebookInstanceStatus = it.notebookInstanceStatus?.value
            notebookInstanceStatus == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it.notebookInstanceStatus?.value
            notebookInstanceStatus == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceStopped(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilProcessingJobCompletedOrStopped(request: DescribeProcessingJobRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeProcessingJobResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeProcessingJobRequest, DescribeProcessingJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val processingJobStatus = it.processingJobStatus?.value
            processingJobStatus == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val processingJobStatus = it.processingJobStatus?.value
            processingJobStatus == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val processingJobStatus = it.processingJobStatus?.value
            processingJobStatus == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeProcessingJob(request) }
}

public suspend fun SageMakerClient.waitUntilProcessingJobCompletedOrStopped(block: DescribeProcessingJobRequest.Builder.() -> Unit): Outcome<DescribeProcessingJobResponse> =
    waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilTrainingJobCompletedOrStopped(request: DescribeTrainingJobRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeTrainingJobResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 120_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTrainingJobRequest, DescribeTrainingJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val trainingJobStatus = it.trainingJobStatus?.value
            trainingJobStatus == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val trainingJobStatus = it.trainingJobStatus?.value
            trainingJobStatus == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val trainingJobStatus = it.trainingJobStatus?.value
            trainingJobStatus == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTrainingJob(request) }
}

public suspend fun SageMakerClient.waitUntilTrainingJobCompletedOrStopped(block: DescribeTrainingJobRequest.Builder.() -> Unit): Outcome<DescribeTrainingJobResponse> =
    waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilTransformJobCompletedOrStopped(request: DescribeTransformJobRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeTransformJobResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTransformJobRequest, DescribeTransformJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val transformJobStatus = it.transformJobStatus?.value
            transformJobStatus == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val transformJobStatus = it.transformJobStatus?.value
            transformJobStatus == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val transformJobStatus = it.transformJobStatus?.value
            transformJobStatus == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTransformJob(request) }
}

public suspend fun SageMakerClient.waitUntilTransformJobCompletedOrStopped(block: DescribeTransformJobRequest.Builder.() -> Unit): Outcome<DescribeTransformJobResponse> =
    waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest.Builder().apply(block).build())
