// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingPlanResponse
import aws.sdk.kotlin.services.sagemaker.model.ReservedCapacitySummary
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.SageMakerResourceName
import aws.sdk.kotlin.services.sagemaker.model.TrainingPlanStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeTrainingPlanOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTrainingPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTrainingPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrainingPlanError(context, call, payload)
        }
        val builder = DescribeTrainingPlanResponse.Builder()

        if (payload != null) {
            deserializeDescribeTrainingPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTrainingPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrainingPlanOperationBody(builder: DescribeTrainingPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABLEINSTANCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("AvailableInstanceCount"))
    val CURRENCYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CurrencyCode"))
    val DURATIONHOURS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("DurationHours"))
    val DURATIONMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("DurationMinutes"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val INUSEINSTANCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InUseInstanceCount"))
    val RESERVEDCAPACITYSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReservedCapacitySummaries"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val TARGETRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TargetResources"))
    val TOTALINSTANCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalInstanceCount"))
    val TRAININGPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingPlanArn"))
    val TRAININGPLANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingPlanName"))
    val UPFRONTFEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpfrontFee"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABLEINSTANCECOUNT_DESCRIPTOR)
        field(CURRENCYCODE_DESCRIPTOR)
        field(DURATIONHOURS_DESCRIPTOR)
        field(DURATIONMINUTES_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(INUSEINSTANCECOUNT_DESCRIPTOR)
        field(RESERVEDCAPACITYSUMMARIES_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(TARGETRESOURCES_DESCRIPTOR)
        field(TOTALINSTANCECOUNT_DESCRIPTOR)
        field(TRAININGPLANARN_DESCRIPTOR)
        field(TRAININGPLANNAME_DESCRIPTOR)
        field(UPFRONTFEE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABLEINSTANCECOUNT_DESCRIPTOR.index -> builder.availableInstanceCount = deserializeInt()
                CURRENCYCODE_DESCRIPTOR.index -> builder.currencyCode = deserializeString()
                DURATIONHOURS_DESCRIPTOR.index -> builder.durationHours = deserializeLong()
                DURATIONMINUTES_DESCRIPTOR.index -> builder.durationMinutes = deserializeLong()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INUSEINSTANCECOUNT_DESCRIPTOR.index -> builder.inUseInstanceCount = deserializeInt()
                RESERVEDCAPACITYSUMMARIES_DESCRIPTOR.index -> builder.reservedCapacitySummaries =
                    deserializer.deserializeList(RESERVEDCAPACITYSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedCapacitySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedCapacitySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TrainingPlanStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                TARGETRESOURCES_DESCRIPTOR.index -> builder.targetResources =
                    deserializer.deserializeList(TARGETRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<SageMakerResourceName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { SageMakerResourceName.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALINSTANCECOUNT_DESCRIPTOR.index -> builder.totalInstanceCount = deserializeInt()
                TRAININGPLANARN_DESCRIPTOR.index -> builder.trainingPlanArn = deserializeString()
                TRAININGPLANNAME_DESCRIPTOR.index -> builder.trainingPlanName = deserializeString()
                UPFRONTFEE_DESCRIPTOR.index -> builder.upfrontFee = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
