// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribePartnerAppResponse
import aws.sdk.kotlin.services.sagemaker.model.ErrorInfo
import aws.sdk.kotlin.services.sagemaker.model.PartnerAppAuthType
import aws.sdk.kotlin.services.sagemaker.model.PartnerAppConfig
import aws.sdk.kotlin.services.sagemaker.model.PartnerAppMaintenanceConfig
import aws.sdk.kotlin.services.sagemaker.model.PartnerAppStatus
import aws.sdk.kotlin.services.sagemaker.model.PartnerAppType
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribePartnerAppOperationDeserializer: HttpDeserializer.NonStreaming<DescribePartnerAppResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePartnerAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePartnerAppError(context, call, payload)
        }
        val builder = DescribePartnerAppResponse.Builder()

        if (payload != null) {
            deserializeDescribePartnerAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePartnerAppError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePartnerAppOperationBody(builder: DescribePartnerAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApplicationConfig"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthType"))
    val BASEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaseUrl"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENABLEIAMSESSIONBASEDIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableIamSessionBasedIdentity"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Error"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val MAINTENANCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MaintenanceConfig"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tier"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONCONFIG_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(AUTHTYPE_DESCRIPTOR)
        field(BASEURL_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ENABLEIAMSESSIONBASEDIDENTITY_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(MAINTENANCECONFIG_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONCONFIG_DESCRIPTOR.index -> builder.applicationConfig = deserializePartnerAppConfigDocument(deserializer)
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString().let { PartnerAppAuthType.fromValue(it) }
                BASEURL_DESCRIPTOR.index -> builder.baseUrl = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENABLEIAMSESSIONBASEDIDENTITY_DESCRIPTOR.index -> builder.enableIamSessionBasedIdentity = deserializeBoolean()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorInfoDocument(deserializer)
                EXECUTIONROLEARN_DESCRIPTOR.index -> builder.executionRoleArn = deserializeString()
                MAINTENANCECONFIG_DESCRIPTOR.index -> builder.maintenanceConfig = deserializePartnerAppMaintenanceConfigDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { PartnerAppStatus.fromValue(it) }
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { PartnerAppType.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
