// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition
import aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation
import aws.sdk.kotlin.services.sagemaker.model.DescribeModelResponse
import aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelError(context, call, payload)
        }
        val builder = DescribeModelResponse.Builder()

        if (payload != null) {
            deserializeDescribeModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelOperationBody(builder: DescribeModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTAINERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Containers"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEPLOYMENTRECOMMENDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeploymentRecommendation"))
    val ENABLENETWORKISOLATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableNetworkIsolation"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val INFERENCEEXECUTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferenceExecutionConfig"))
    val MODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelArn"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelName"))
    val PRIMARYCONTAINER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PrimaryContainer"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINERS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DEPLOYMENTRECOMMENDATION_DESCRIPTOR)
        field(ENABLENETWORKISOLATION_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(INFERENCEEXECUTIONCONFIG_DESCRIPTOR)
        field(MODELARN_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
        field(PRIMARYCONTAINER_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTAINERS_DESCRIPTOR.index -> builder.containers =
                    deserializer.deserializeList(CONTAINERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ContainerDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContainerDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEPLOYMENTRECOMMENDATION_DESCRIPTOR.index -> builder.deploymentRecommendation = deserializeDeploymentRecommendationDocument(deserializer)
                ENABLENETWORKISOLATION_DESCRIPTOR.index -> builder.enableNetworkIsolation = deserializeBoolean()
                EXECUTIONROLEARN_DESCRIPTOR.index -> builder.executionRoleArn = deserializeString()
                INFERENCEEXECUTIONCONFIG_DESCRIPTOR.index -> builder.inferenceExecutionConfig = deserializeInferenceExecutionConfigDocument(deserializer)
                MODELARN_DESCRIPTOR.index -> builder.modelArn = deserializeString()
                MODELNAME_DESCRIPTOR.index -> builder.modelName = deserializeString()
                PRIMARYCONTAINER_DESCRIPTOR.index -> builder.primaryContainer = deserializeContainerDefinitionDocument(deserializer)
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
