// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeMlflowTrackingServerResponse
import aws.sdk.kotlin.services.sagemaker.model.IsTrackingServerActive
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrackingServerSize
import aws.sdk.kotlin.services.sagemaker.model.TrackingServerStatus
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeMlflowTrackingServerOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMlflowTrackingServerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMlflowTrackingServerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMlflowTrackingServerError(context, call, payload)
        }
        val builder = DescribeMlflowTrackingServerResponse.Builder()

        if (payload != null) {
            deserializeDescribeMlflowTrackingServerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMlflowTrackingServerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMlflowTrackingServerOperationBody(builder: DescribeMlflowTrackingServerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARTIFACTSTOREURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactStoreUri"))
    val AUTOMATICMODELREGISTRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutomaticModelRegistration"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ISACTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IsActive"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MLFLOWVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MlflowVersion"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val TRACKINGSERVERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrackingServerArn"))
    val TRACKINGSERVERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrackingServerName"))
    val TRACKINGSERVERSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TrackingServerSize"))
    val TRACKINGSERVERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TrackingServerStatus"))
    val TRACKINGSERVERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrackingServerUrl"))
    val WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WeeklyMaintenanceWindowStart"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTSTOREURI_DESCRIPTOR)
        field(AUTOMATICMODELREGISTRATION_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ISACTIVE_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MLFLOWVERSION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TRACKINGSERVERARN_DESCRIPTOR)
        field(TRACKINGSERVERNAME_DESCRIPTOR)
        field(TRACKINGSERVERSIZE_DESCRIPTOR)
        field(TRACKINGSERVERSTATUS_DESCRIPTOR)
        field(TRACKINGSERVERURL_DESCRIPTOR)
        field(WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARTIFACTSTOREURI_DESCRIPTOR.index -> builder.artifactStoreUri = deserializeString()
                AUTOMATICMODELREGISTRATION_DESCRIPTOR.index -> builder.automaticModelRegistration = deserializeBoolean()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ISACTIVE_DESCRIPTOR.index -> builder.isActive = deserializeString().let { IsTrackingServerActive.fromValue(it) }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MLFLOWVERSION_DESCRIPTOR.index -> builder.mlflowVersion = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                TRACKINGSERVERARN_DESCRIPTOR.index -> builder.trackingServerArn = deserializeString()
                TRACKINGSERVERNAME_DESCRIPTOR.index -> builder.trackingServerName = deserializeString()
                TRACKINGSERVERSIZE_DESCRIPTOR.index -> builder.trackingServerSize = deserializeString().let { TrackingServerSize.fromValue(it) }
                TRACKINGSERVERSTATUS_DESCRIPTOR.index -> builder.trackingServerStatus = deserializeString().let { TrackingServerStatus.fromValue(it) }
                TRACKINGSERVERURL_DESCRIPTOR.index -> builder.trackingServerUrl = deserializeString()
                WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR.index -> builder.weeklyMaintenanceWindowStart = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
