// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.ActivationState
import aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaConfig
import aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaTarget
import aws.sdk.kotlin.services.sagemaker.model.DescribeComputeQuotaResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.SchedulerResourceStatus
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeComputeQuotaOperationDeserializer: HttpDeserializer.NonStreaming<DescribeComputeQuotaResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeComputeQuotaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeComputeQuotaError(context, call, payload)
        }
        val builder = DescribeComputeQuotaResponse.Builder()

        if (payload != null) {
            deserializeDescribeComputeQuotaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeComputeQuotaError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeComputeQuotaOperationBody(builder: DescribeComputeQuotaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ActivationState"))
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterArn"))
    val COMPUTEQUOTAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeQuotaArn"))
    val COMPUTEQUOTACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ComputeQuotaConfig"))
    val COMPUTEQUOTAID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeQuotaId"))
    val COMPUTEQUOTATARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ComputeQuotaTarget"))
    val COMPUTEQUOTAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ComputeQuotaVersion"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVATIONSTATE_DESCRIPTOR)
        field(CLUSTERARN_DESCRIPTOR)
        field(COMPUTEQUOTAARN_DESCRIPTOR)
        field(COMPUTEQUOTACONFIG_DESCRIPTOR)
        field(COMPUTEQUOTAID_DESCRIPTOR)
        field(COMPUTEQUOTATARGET_DESCRIPTOR)
        field(COMPUTEQUOTAVERSION_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVATIONSTATE_DESCRIPTOR.index -> builder.activationState = deserializeString().let { ActivationState.fromValue(it) }
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                COMPUTEQUOTAARN_DESCRIPTOR.index -> builder.computeQuotaArn = deserializeString()
                COMPUTEQUOTACONFIG_DESCRIPTOR.index -> builder.computeQuotaConfig = deserializeComputeQuotaConfigDocument(deserializer)
                COMPUTEQUOTAID_DESCRIPTOR.index -> builder.computeQuotaId = deserializeString()
                COMPUTEQUOTATARGET_DESCRIPTOR.index -> builder.computeQuotaTarget = deserializeComputeQuotaTargetDocument(deserializer)
                COMPUTEQUOTAVERSION_DESCRIPTOR.index -> builder.computeQuotaVersion = deserializeInt()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SchedulerResourceStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
