// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of the training plan.
 *
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> `.
 */
public class TrainingPlanSummary private constructor(builder: Builder) {
    /**
     * The number of instances currently available for use in this training plan.
     */
    public val availableInstanceCount: kotlin.Int? = builder.availableInstanceCount
    /**
     * The currency code for the upfront fee (e.g., USD).
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The number of whole hours in the total duration for this training plan.
     */
    public val durationHours: kotlin.Long? = builder.durationHours
    /**
     * The additional minutes beyond whole hours in the total duration for this training plan.
     */
    public val durationMinutes: kotlin.Long? = builder.durationMinutes
    /**
     * The end time of the training plan.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The number of instances currently in use from this training plan.
     */
    public val inUseInstanceCount: kotlin.Int? = builder.inUseInstanceCount
    /**
     * A list of reserved capacities associated with this training plan, including details such as instance types, counts, and availability zones.
     */
    public val reservedCapacitySummaries: List<ReservedCapacitySummary>? = builder.reservedCapacitySummaries
    /**
     * The start time of the training plan.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status values available for a training plan, refer to the `Status` attribute within the ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> ` object.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.TrainingPlanStatus? = builder.status
    /**
     * A message providing additional information about the current status of the training plan.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The target resources (e.g., training jobs, HyperPod clusters) that can use this training plan.
     *
     * Training plans are specific to their target resource.
     * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
     */
    public val targetResources: List<SageMakerResourceName>? = builder.targetResources
    /**
     * The total number of instances reserved in this training plan.
     */
    public val totalInstanceCount: kotlin.Int? = builder.totalInstanceCount
    /**
     * The Amazon Resource Name (ARN); of the training plan.
     */
    public val trainingPlanArn: kotlin.String? = builder.trainingPlanArn
    /**
     * The name of the training plan.
     */
    public val trainingPlanName: kotlin.String? = builder.trainingPlanName
    /**
     * The upfront fee for the training plan.
     */
    public val upfrontFee: kotlin.String? = builder.upfrontFee

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingPlanSummary(")
        append("availableInstanceCount=$availableInstanceCount,")
        append("currencyCode=$currencyCode,")
        append("durationHours=$durationHours,")
        append("durationMinutes=$durationMinutes,")
        append("endTime=$endTime,")
        append("inUseInstanceCount=$inUseInstanceCount,")
        append("reservedCapacitySummaries=$reservedCapacitySummaries,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("targetResources=$targetResources,")
        append("totalInstanceCount=$totalInstanceCount,")
        append("trainingPlanArn=$trainingPlanArn,")
        append("trainingPlanName=$trainingPlanName,")
        append("upfrontFee=$upfrontFee")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableInstanceCount ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (durationHours?.hashCode() ?: 0)
        result = 31 * result + (durationMinutes?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inUseInstanceCount ?: 0)
        result = 31 * result + (reservedCapacitySummaries?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (targetResources?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        result = 31 * result + (trainingPlanArn?.hashCode() ?: 0)
        result = 31 * result + (trainingPlanName?.hashCode() ?: 0)
        result = 31 * result + (upfrontFee?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingPlanSummary

        if (availableInstanceCount != other.availableInstanceCount) return false
        if (currencyCode != other.currencyCode) return false
        if (durationHours != other.durationHours) return false
        if (durationMinutes != other.durationMinutes) return false
        if (endTime != other.endTime) return false
        if (inUseInstanceCount != other.inUseInstanceCount) return false
        if (reservedCapacitySummaries != other.reservedCapacitySummaries) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (targetResources != other.targetResources) return false
        if (totalInstanceCount != other.totalInstanceCount) return false
        if (trainingPlanArn != other.trainingPlanArn) return false
        if (trainingPlanName != other.trainingPlanName) return false
        if (upfrontFee != other.upfrontFee) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of instances currently available for use in this training plan.
         */
        public var availableInstanceCount: kotlin.Int? = null
        /**
         * The currency code for the upfront fee (e.g., USD).
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The number of whole hours in the total duration for this training plan.
         */
        public var durationHours: kotlin.Long? = null
        /**
         * The additional minutes beyond whole hours in the total duration for this training plan.
         */
        public var durationMinutes: kotlin.Long? = null
        /**
         * The end time of the training plan.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of instances currently in use from this training plan.
         */
        public var inUseInstanceCount: kotlin.Int? = null
        /**
         * A list of reserved capacities associated with this training plan, including details such as instance types, counts, and availability zones.
         */
        public var reservedCapacitySummaries: List<ReservedCapacitySummary>? = null
        /**
         * The start time of the training plan.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status values available for a training plan, refer to the `Status` attribute within the ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> ` object.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.TrainingPlanStatus? = null
        /**
         * A message providing additional information about the current status of the training plan.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The target resources (e.g., training jobs, HyperPod clusters) that can use this training plan.
         *
         * Training plans are specific to their target resource.
         * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
         */
        public var targetResources: List<SageMakerResourceName>? = null
        /**
         * The total number of instances reserved in this training plan.
         */
        public var totalInstanceCount: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN); of the training plan.
         */
        public var trainingPlanArn: kotlin.String? = null
        /**
         * The name of the training plan.
         */
        public var trainingPlanName: kotlin.String? = null
        /**
         * The upfront fee for the training plan.
         */
        public var upfrontFee: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingPlanSummary) : this() {
            this.availableInstanceCount = x.availableInstanceCount
            this.currencyCode = x.currencyCode
            this.durationHours = x.durationHours
            this.durationMinutes = x.durationMinutes
            this.endTime = x.endTime
            this.inUseInstanceCount = x.inUseInstanceCount
            this.reservedCapacitySummaries = x.reservedCapacitySummaries
            this.startTime = x.startTime
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.targetResources = x.targetResources
            this.totalInstanceCount = x.totalInstanceCount
            this.trainingPlanArn = x.trainingPlanArn
            this.trainingPlanName = x.trainingPlanName
            this.upfrontFee = x.upfrontFee
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanSummary = TrainingPlanSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
