// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a training plan offering.
 *
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> `.
 */
public class TrainingPlanOffering private constructor(builder: Builder) {
    /**
     * The currency code for the upfront fee (e.g., USD).
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The number of whole hours in the total duration for this training plan offering.
     */
    public val durationHours: kotlin.Long? = builder.durationHours
    /**
     * The additional minutes beyond whole hours in the total duration for this training plan offering.
     */
    public val durationMinutes: kotlin.Long? = builder.durationMinutes
    /**
     * The requested end time that the user specified when searching for the training plan offering.
     */
    public val requestedEndTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedEndTimeBefore
    /**
     * The requested start time that the user specified when searching for the training plan offering.
     */
    public val requestedStartTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedStartTimeAfter
    /**
     * A list of reserved capacity offerings associated with this training plan offering.
     */
    public val reservedCapacityOfferings: List<ReservedCapacityOffering>? = builder.reservedCapacityOfferings
    /**
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) for this training plan offering.
     *
     * Training plans are specific to their target resource.
     * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
     */
    public val targetResources: List<SageMakerResourceName>? = builder.targetResources
    /**
     * The unique identifier for this training plan offering.
     */
    public val trainingPlanOfferingId: kotlin.String? = builder.trainingPlanOfferingId
    /**
     * The upfront fee for this training plan offering.
     */
    public val upfrontFee: kotlin.String? = builder.upfrontFee

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingPlanOffering(")
        append("currencyCode=$currencyCode,")
        append("durationHours=$durationHours,")
        append("durationMinutes=$durationMinutes,")
        append("requestedEndTimeBefore=$requestedEndTimeBefore,")
        append("requestedStartTimeAfter=$requestedStartTimeAfter,")
        append("reservedCapacityOfferings=$reservedCapacityOfferings,")
        append("targetResources=$targetResources,")
        append("trainingPlanOfferingId=$trainingPlanOfferingId,")
        append("upfrontFee=$upfrontFee")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (durationHours?.hashCode() ?: 0)
        result = 31 * result + (durationMinutes?.hashCode() ?: 0)
        result = 31 * result + (requestedEndTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (requestedStartTimeAfter?.hashCode() ?: 0)
        result = 31 * result + (reservedCapacityOfferings?.hashCode() ?: 0)
        result = 31 * result + (targetResources?.hashCode() ?: 0)
        result = 31 * result + (trainingPlanOfferingId?.hashCode() ?: 0)
        result = 31 * result + (upfrontFee?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingPlanOffering

        if (currencyCode != other.currencyCode) return false
        if (durationHours != other.durationHours) return false
        if (durationMinutes != other.durationMinutes) return false
        if (requestedEndTimeBefore != other.requestedEndTimeBefore) return false
        if (requestedStartTimeAfter != other.requestedStartTimeAfter) return false
        if (reservedCapacityOfferings != other.reservedCapacityOfferings) return false
        if (targetResources != other.targetResources) return false
        if (trainingPlanOfferingId != other.trainingPlanOfferingId) return false
        if (upfrontFee != other.upfrontFee) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanOffering = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The currency code for the upfront fee (e.g., USD).
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The number of whole hours in the total duration for this training plan offering.
         */
        public var durationHours: kotlin.Long? = null
        /**
         * The additional minutes beyond whole hours in the total duration for this training plan offering.
         */
        public var durationMinutes: kotlin.Long? = null
        /**
         * The requested end time that the user specified when searching for the training plan offering.
         */
        public var requestedEndTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The requested start time that the user specified when searching for the training plan offering.
         */
        public var requestedStartTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of reserved capacity offerings associated with this training plan offering.
         */
        public var reservedCapacityOfferings: List<ReservedCapacityOffering>? = null
        /**
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) for this training plan offering.
         *
         * Training plans are specific to their target resource.
         * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
         */
        public var targetResources: List<SageMakerResourceName>? = null
        /**
         * The unique identifier for this training plan offering.
         */
        public var trainingPlanOfferingId: kotlin.String? = null
        /**
         * The upfront fee for this training plan offering.
         */
        public var upfrontFee: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingPlanOffering) : this() {
            this.currencyCode = x.currencyCode
            this.durationHours = x.durationHours
            this.durationMinutes = x.durationMinutes
            this.requestedEndTimeBefore = x.requestedEndTimeBefore
            this.requestedStartTimeAfter = x.requestedStartTimeAfter
            this.reservedCapacityOfferings = x.reservedCapacityOfferings
            this.targetResources = x.targetResources
            this.trainingPlanOfferingId = x.trainingPlanOfferingId
            this.upfrontFee = x.upfrontFee
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingPlanOffering = TrainingPlanOffering(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
