// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.
 */
public class TrainingJobStatusCounters private constructor(builder: Builder) {
    /**
     * The number of completed training jobs launched by the hyperparameter tuning job.
     */
    public val completed: kotlin.Int? = builder.completed
    /**
     * The number of in-progress training jobs launched by a hyperparameter tuning job.
     */
    public val inProgress: kotlin.Int? = builder.inProgress
    /**
     * The number of training jobs that failed and can't be retried. A failed training job can't be retried if it failed because a client error occurred.
     */
    public val nonRetryableError: kotlin.Int? = builder.nonRetryableError
    /**
     * The number of training jobs that failed, but can be retried. A failed training job can be retried only if it failed because an internal service error occurred.
     */
    public val retryableError: kotlin.Int? = builder.retryableError
    /**
     * The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
     */
    public val stopped: kotlin.Int? = builder.stopped

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingJobStatusCounters(")
        append("completed=$completed,")
        append("inProgress=$inProgress,")
        append("nonRetryableError=$nonRetryableError,")
        append("retryableError=$retryableError,")
        append("stopped=$stopped")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completed ?: 0
        result = 31 * result + (inProgress ?: 0)
        result = 31 * result + (nonRetryableError ?: 0)
        result = 31 * result + (retryableError ?: 0)
        result = 31 * result + (stopped ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingJobStatusCounters

        if (completed != other.completed) return false
        if (inProgress != other.inProgress) return false
        if (nonRetryableError != other.nonRetryableError) return false
        if (retryableError != other.retryableError) return false
        if (stopped != other.stopped) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of completed training jobs launched by the hyperparameter tuning job.
         */
        public var completed: kotlin.Int? = null
        /**
         * The number of in-progress training jobs launched by a hyperparameter tuning job.
         */
        public var inProgress: kotlin.Int? = null
        /**
         * The number of training jobs that failed and can't be retried. A failed training job can't be retried if it failed because a client error occurred.
         */
        public var nonRetryableError: kotlin.Int? = null
        /**
         * The number of training jobs that failed, but can be retried. A failed training job can be retried only if it failed because an internal service error occurred.
         */
        public var retryableError: kotlin.Int? = null
        /**
         * The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
         */
        public var stopped: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters) : this() {
            this.completed = x.completed
            this.inProgress = x.inProgress
            this.nonRetryableError = x.nonRetryableError
            this.retryableError = x.retryableError
            this.stopped = x.stopped
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters = TrainingJobStatusCounters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
