// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A collection of space settings.
 */
public class SpaceSettings private constructor(builder: Builder) {
    /**
     * The type of app created within the space.
     *
     * If using the [ UpdateSpace](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html) API, you can't change the app type of your space by specifying a different value for this field.
     */
    public val appType: aws.sdk.kotlin.services.sagemaker.model.AppType? = builder.appType
    /**
     * The Code Editor application settings.
     */
    public val codeEditorAppSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceCodeEditorAppSettings? = builder.codeEditorAppSettings
    /**
     * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users can access this file system in Amazon SageMaker AI Studio.
     */
    public val customFileSystems: List<CustomFileSystem>? = builder.customFileSystems
    /**
     * The settings for the JupyterLab application.
     */
    public val jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceJupyterLabAppSettings? = builder.jupyterLabAppSettings
    /**
     * The JupyterServer app settings.
     */
    public val jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = builder.jupyterServerAppSettings
    /**
     * The KernelGateway app settings.
     */
    public val kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = builder.kernelGatewayAppSettings
    /**
     * The storage settings for a space.
     */
    public val spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceStorageSettings? = builder.spaceStorageSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SpaceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpaceSettings(")
        append("appType=$appType,")
        append("codeEditorAppSettings=$codeEditorAppSettings,")
        append("customFileSystems=$customFileSystems,")
        append("jupyterLabAppSettings=$jupyterLabAppSettings,")
        append("jupyterServerAppSettings=$jupyterServerAppSettings,")
        append("kernelGatewayAppSettings=$kernelGatewayAppSettings,")
        append("spaceStorageSettings=$spaceStorageSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appType?.hashCode() ?: 0
        result = 31 * result + (codeEditorAppSettings?.hashCode() ?: 0)
        result = 31 * result + (customFileSystems?.hashCode() ?: 0)
        result = 31 * result + (jupyterLabAppSettings?.hashCode() ?: 0)
        result = 31 * result + (jupyterServerAppSettings?.hashCode() ?: 0)
        result = 31 * result + (kernelGatewayAppSettings?.hashCode() ?: 0)
        result = 31 * result + (spaceStorageSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpaceSettings

        if (appType != other.appType) return false
        if (codeEditorAppSettings != other.codeEditorAppSettings) return false
        if (customFileSystems != other.customFileSystems) return false
        if (jupyterLabAppSettings != other.jupyterLabAppSettings) return false
        if (jupyterServerAppSettings != other.jupyterServerAppSettings) return false
        if (kernelGatewayAppSettings != other.kernelGatewayAppSettings) return false
        if (spaceStorageSettings != other.spaceStorageSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SpaceSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of app created within the space.
         *
         * If using the [ UpdateSpace](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html) API, you can't change the app type of your space by specifying a different value for this field.
         */
        public var appType: aws.sdk.kotlin.services.sagemaker.model.AppType? = null
        /**
         * The Code Editor application settings.
         */
        public var codeEditorAppSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceCodeEditorAppSettings? = null
        /**
         * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users can access this file system in Amazon SageMaker AI Studio.
         */
        public var customFileSystems: List<CustomFileSystem>? = null
        /**
         * The settings for the JupyterLab application.
         */
        public var jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceJupyterLabAppSettings? = null
        /**
         * The JupyterServer app settings.
         */
        public var jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = null
        /**
         * The KernelGateway app settings.
         */
        public var kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = null
        /**
         * The storage settings for a space.
         */
        public var spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.SpaceStorageSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SpaceSettings) : this() {
            this.appType = x.appType
            this.codeEditorAppSettings = x.codeEditorAppSettings
            this.customFileSystems = x.customFileSystems
            this.jupyterLabAppSettings = x.jupyterLabAppSettings
            this.jupyterServerAppSettings = x.jupyterServerAppSettings
            this.kernelGatewayAppSettings = x.kernelGatewayAppSettings
            this.spaceStorageSettings = x.spaceStorageSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SpaceSettings = SpaceSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SpaceCodeEditorAppSettings] inside the given [block]
         */
        public fun codeEditorAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.SpaceCodeEditorAppSettings.Builder.() -> kotlin.Unit) {
            this.codeEditorAppSettings = aws.sdk.kotlin.services.sagemaker.model.SpaceCodeEditorAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SpaceJupyterLabAppSettings] inside the given [block]
         */
        public fun jupyterLabAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.SpaceJupyterLabAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterLabAppSettings = aws.sdk.kotlin.services.sagemaker.model.SpaceJupyterLabAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings] inside the given [block]
         */
        public fun jupyterServerAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterServerAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings] inside the given [block]
         */
        public fun kernelGatewayAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.Builder.() -> kotlin.Unit) {
            this.kernelGatewayAppSettings = aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SpaceStorageSettings] inside the given [block]
         */
        public fun spaceStorageSettings(block: aws.sdk.kotlin.services.sagemaker.model.SpaceStorageSettings.Builder.() -> kotlin.Unit) {
            this.spaceStorageSettings = aws.sdk.kotlin.services.sagemaker.model.SpaceStorageSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
