// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration for a shuffle option for input data in a channel. If you use `S3Prefix` for `S3DataType`, the results of the S3 key prefix matches are shuffled. If you use `ManifestFile`, the order of the S3 object references in the `ManifestFile` is shuffled. If you use `AugmentedManifestFile`, the order of the JSON lines in the `AugmentedManifestFile` is shuffled. The shuffling order is determined using the `Seed` value.
 *
 * For Pipe input mode, when `ShuffleConfig` is specified shuffling is done at the start of every epoch. With large datasets, this ensures that the order of the training data is different for each epoch, and it helps reduce bias and possible overfitting. In a multi-node training job when `ShuffleConfig` is combined with `S3DataDistributionType` of `ShardedByS3Key`, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.
 */
public class ShuffleConfig private constructor(builder: Builder) {
    /**
     * Determines the shuffling order in `ShuffleConfig` value.
     */
    public val seed: kotlin.Long? = builder.seed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ShuffleConfig(")
        append("seed=$seed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = seed?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ShuffleConfig

        if (seed != other.seed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines the shuffling order in `ShuffleConfig` value.
         */
        public var seed: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig) : this() {
            this.seed = x.seed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ShuffleConfig = ShuffleConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
