// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class SearchTrainingPlanOfferingsRequest private constructor(builder: Builder) {
    /**
     * The desired duration in hours for the training plan offerings.
     */
    public val durationHours: kotlin.Long? = builder.durationHours
    /**
     * A filter to search for reserved capacity offerings with an end time before a specified date.
     */
    public val endTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimeBefore
    /**
     * The number of instances you want to reserve in the training plan offerings. This allows you to specify the quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod clusters, helping you find reserved capacity offerings that match your requirements.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The type of instance you want to search for in the available training plan offerings. This field allows you to filter the search results based on the specific compute resources you require for your SageMaker training jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type helps you find Reserved Instances that match your computational needs.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = builder.instanceType
    /**
     * A filter to search for training plan offerings with a start time after a specified date.
     */
    public val startTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimeAfter
    /**
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
     *
     * Training plans are specific to their target resource.
     * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
     */
    public val targetResources: List<SageMakerResourceName>? = builder.targetResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SearchTrainingPlanOfferingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchTrainingPlanOfferingsRequest(")
        append("durationHours=$durationHours,")
        append("endTimeBefore=$endTimeBefore,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("startTimeAfter=$startTimeAfter,")
        append("targetResources=$targetResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationHours?.hashCode() ?: 0
        result = 31 * result + (endTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (startTimeAfter?.hashCode() ?: 0)
        result = 31 * result + (targetResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchTrainingPlanOfferingsRequest

        if (durationHours != other.durationHours) return false
        if (endTimeBefore != other.endTimeBefore) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (startTimeAfter != other.startTimeAfter) return false
        if (targetResources != other.targetResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SearchTrainingPlanOfferingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The desired duration in hours for the training plan offerings.
         */
        public var durationHours: kotlin.Long? = null
        /**
         * A filter to search for reserved capacity offerings with an end time before a specified date.
         */
        public var endTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of instances you want to reserve in the training plan offerings. This allows you to specify the quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod clusters, helping you find reserved capacity offerings that match your requirements.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The type of instance you want to search for in the available training plan offerings. This field allows you to filter the search results based on the specific compute resources you require for your SageMaker training jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type helps you find Reserved Instances that match your computational needs.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = null
        /**
         * A filter to search for training plan offerings with a start time after a specified date.
         */
        public var startTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
         *
         * Training plans are specific to their target resource.
         * + A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * + A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's instance group.
         */
        public var targetResources: List<SageMakerResourceName>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SearchTrainingPlanOfferingsRequest) : this() {
            this.durationHours = x.durationHours
            this.endTimeBefore = x.endTimeBefore
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.startTimeAfter = x.startTimeAfter
            this.targetResources = x.targetResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SearchTrainingPlanOfferingsRequest = SearchTrainingPlanOfferingsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
