// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of a reserved capacity for the training plan.
 *
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> `.
 */
public class ReservedCapacitySummary private constructor(builder: Builder) {
    /**
     * The availability zone for the reserved capacity.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of whole hours in the total duration for this reserved capacity.
     */
    public val durationHours: kotlin.Long? = builder.durationHours
    /**
     * The additional minutes beyond whole hours in the total duration for this reserved capacity.
     */
    public val durationMinutes: kotlin.Long? = builder.durationMinutes
    /**
     * The end time of the reserved capacity.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The instance type for the reserved capacity.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN); of the reserved capacity.
     */
    public val reservedCapacityArn: kotlin.String? = builder.reservedCapacityArn
    /**
     * The start time of the reserved capacity.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status of the reserved capacity.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityStatus? = builder.status
    /**
     * The total number of instances in the reserved capacity.
     */
    public val totalInstanceCount: kotlin.Int? = builder.totalInstanceCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacitySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedCapacitySummary(")
        append("availabilityZone=$availabilityZone,")
        append("durationHours=$durationHours,")
        append("durationMinutes=$durationMinutes,")
        append("endTime=$endTime,")
        append("instanceType=$instanceType,")
        append("reservedCapacityArn=$reservedCapacityArn,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("totalInstanceCount=$totalInstanceCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (durationHours?.hashCode() ?: 0)
        result = 31 * result + (durationMinutes?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (reservedCapacityArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedCapacitySummary

        if (availabilityZone != other.availabilityZone) return false
        if (durationHours != other.durationHours) return false
        if (durationMinutes != other.durationMinutes) return false
        if (endTime != other.endTime) return false
        if (instanceType != other.instanceType) return false
        if (reservedCapacityArn != other.reservedCapacityArn) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (totalInstanceCount != other.totalInstanceCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacitySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The availability zone for the reserved capacity.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of whole hours in the total duration for this reserved capacity.
         */
        public var durationHours: kotlin.Long? = null
        /**
         * The additional minutes beyond whole hours in the total duration for this reserved capacity.
         */
        public var durationMinutes: kotlin.Long? = null
        /**
         * The end time of the reserved capacity.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The instance type for the reserved capacity.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = null
        /**
         * The Amazon Resource Name (ARN); of the reserved capacity.
         */
        public var reservedCapacityArn: kotlin.String? = null
        /**
         * The start time of the reserved capacity.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the reserved capacity.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityStatus? = null
        /**
         * The total number of instances in the reserved capacity.
         */
        public var totalInstanceCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacitySummary) : this() {
            this.availabilityZone = x.availabilityZone
            this.durationHours = x.durationHours
            this.durationMinutes = x.durationMinutes
            this.endTime = x.endTime
            this.instanceType = x.instanceType
            this.reservedCapacityArn = x.reservedCapacityArn
            this.startTime = x.startTime
            this.status = x.status
            this.totalInstanceCount = x.totalInstanceCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacitySummary = ReservedCapacitySummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
